/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.optimization.unconstrained.NelderMead;
import com.numericalmethod.suanshu.optimization.unconstrained.UnconstrainedMinimizer;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class UnconstrainedMaximizer {
    private final UnconstrainedMinimizer E;

    public UnconstrainedMaximizer(UnconstrainedMinimizer minimizer) {
        this.E = minimizer;
    }

    public void solve(final RealScalarFunction f2, double tol, int maxIterations) {
        RealScalarFunction a2 = new RealScalarFunction(){

            @Override
            public double evaluate(double ... x) {
                return -1.0 * f2.evaluate(x);
            }
            {
                1 a2;
            }

            @Override
            public int dimensionOfDomain() {
                return f2.dimensionOfDomain();
            }

            @Override
            public int dimensionOfRange() {
                return f2.dimensionOfRange();
            }
        };
        this.E.solve(a2, tol, maxIterations);
    }

    public double[] search(double ... initials) {
        Vector[] vectorArray = new Vector[1];
        vectorArray[0] = new DenseVector(initials);
        return this.E.search(vectorArray).toArray();
    }

    public UnconstrainedMaximizer() {
        this(new NelderMead());
    }

    public Vector search(Vector ... initials) {
        return this.E.search(initials);
    }
}

