/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.optimization.initialization.DefaultSimplex;
import com.numericalmethod.suanshu.optimization.unconstrained.UnconstrainedMinimizer;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class NelderMead
implements UnconstrainedMinimizer {
    public final double sigma;
    public final double gamma;
    public static final int MINIMUM_NUMBER_OF_ITERATIONS = 50;
    public final double rho;
    private State E;
    public final double alpha;

    public NelderMead(double alpha, double gamma, double rho, double sigma) {
        this.alpha = alpha;
        this.gamma = gamma;
        this.rho = rho;
        this.sigma = sigma;
    }

    public NelderMead() {
        this(1.0, 2.0, 0.5, 0.5);
    }

    @Override
    public void solve(RealScalarFunction f2, double tol, int maxIterations) {
        this.E = new State(f2, tol, maxIterations, null);
    }

    private void m() {
        int a2;
        NelderMead a3;
        int[] a4 = R.order(a3.E.i);
        Vector[] a5 = new Vector[a3.E.M];
        int n = a2 = 0;
        while (n < a3.E.M) {
            a5[a2] = a3.E.F[a4[a2] - 1];
            n = ++a2;
        }
        Arrays.sort(a3.E.i);
        State.access$402(a3.E, a5);
    }

    @Override
    public double minimum() {
        return this.E.i[0];
    }

    @Override
    public Vector search(Vector ... simplex) {
        int a2;
        int a3;
        if (simplex.length != this.E.M) {
            Vector[] vectorArray = new Vector[1];
            vectorArray[0] = simplex[0];
            return this.search(new DefaultSimplex().getInitials(vectorArray));
        }
        int n = a3 = 0;
        while (n < simplex.length) {
            SuanShuUtils.assertArgument(simplex[a3].size() == this.E.E, "the dimension of x does not match the degree of freedom of f", new Object[0]);
            n = ++a3;
        }
        State.access$402(this.E, simplex);
        State.access$102(this.E, new double[this.E.M]);
        int n2 = a3 = 0;
        while (n2 < this.E.M) {
            ((State)this.E).i[a3] = this.E.G.evaluate(simplex[a3].toArray());
            n2 = ++a3;
        }
        double a22 = Double.POSITIVE_INFINITY;
        this.m();
        int n3 = a2 = 0;
        while (n3 < this.E.k) {
            this.b();
            this.m();
            if (a2 > 50) {
                if (Math.abs(this.E.i[0] - a22) < this.E.L) break;
            }
            a22 = this.E.i[0];
            n3 = ++a2;
        }
        return this.E.F[0];
    }

    /*
     * Enabled aggressive block sorting
     */
    private void b() {
        int a2;
        int a3;
        NelderMead a4;
        Vector a5 = new DenseVector(a4.E.E);
        int n = a3 = 0;
        while (n < a4.E.E) {
            a5 = a5.add(a4.E.F[a3]);
            n = ++a3;
        }
        a5 = a5.scaled(1.0 / (double)a4.E.E);
        Vector a22 = a5.add(a5.minus(a4.E.F[a4.E.E]).scaled(a4.alpha));
        double a6 = a4.E.G.evaluate(a22.toArray());
        if (a4.E.i[0] <= a6) {
            if (a6 < a4.E.i[a4.E.E - 1]) {
                a4.b(a22, a6);
                return;
            }
        }
        if (a6 < a4.E.i[0]) {
            double d2;
            Vector a7 = a5.add(a5.minus(a4.E.F[a4.E.E]).scaled(a4.gamma));
            double a8 = a4.E.G.evaluate(a7.toArray());
            if (d2 < a6) {
                a4.b(a7, a8);
                return;
            }
            a4.b(a22, a6);
            return;
        }
        Vector a9 = a6 < a4.E.i[a4.E.E] ? a5.add(a22.minus(a5).scaled(a4.rho)) : a5.add(a4.E.F[a4.E.E].minus(a5).scaled(a4.rho));
        double a10 = a4.E.G.evaluate(a9.toArray());
        if (a6 < a4.E.i[a4.E.E] && a10 <= a6 || a6 >= a4.E.i[a4.E.E] - 1.0E-14 && a10 < a4.E.i[a4.E.E]) {
            a4.b(a9, a10);
            return;
        }
        int n2 = a2 = 1;
        while (n2 < a4.E.M) {
            ((State)a4.E).F[a2] = a4.E.F[0].add(a4.E.F[a2].minus(a4.E.F[0]).scaled(a4.sigma));
            ((State)a4.E).i[a2] = a4.E.G.evaluate(a4.E.F[a2].toArray());
            n2 = ++a2;
        }
    }

    private void b(Vector a2, double a3) {
        ((State)a.E).F[((State)a.E).E] = a2;
        ((State)a.E).i[((State)a.E).E] = a3;
    }

    public double[] search(double[] ... simplex) {
        int a2;
        int a3 = simplex.length;
        Vector[] a4 = new Vector[a3];
        int n = a2 = 0;
        while (n < a3) {
            a4[a2] = new DenseVector(simplex[a2]);
            n = ++a2;
        }
        Vector a22 = this.search(a4);
        return a22.toArray();
    }

    public static class 1 {
    }

    private static class State {
        private final int M;
        private double[] i;
        private final RealScalarFunction G;
        private Vector[] F;
        private final int k;
        private final double L;
        private final int E;

        public static /* synthetic */ double[] access$102(State a2, double[] a3) {
            a2.i = a3;
            return a3;
        }

        public /* synthetic */ State(RealScalarFunction a2, double a3, int a4, 1 a5) {
            a6(a2, a3, a4);
            State a6;
        }

        private State(RealScalarFunction a2, double a3, int a4) {
            State a5;
            a5.G = a2;
            a5.E = a2.dimensionOfDomain();
            a5.M = a5.E + 1;
            a5.L = a3;
            a5.k = a4;
        }

        public static /* synthetic */ Vector[] access$402(State a2, Vector[] a3) {
            a2.F = a3;
            return a3;
        }
    }
}

