/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.geneticalgorithm.minimizer;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.algorithm.IterativeAlgorithm;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.interval.DoubleInterval;
import com.numericalmethod.suanshu.optimization.geneticalgorithm.Chromosome;
import com.numericalmethod.suanshu.optimization.geneticalgorithm.GeneticAlgorithmImpl;
import com.numericalmethod.suanshu.optimization.geneticalgorithm.minimizer.SimpleCellFactory;
import com.numericalmethod.suanshu.optimization.initialization.UniformDistributionOverBox2;
import com.numericalmethod.suanshu.optimization.unconstrained.UnconstrainedMinimizer;
import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.UniformRng;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.ArrayList;
import java.util.Arrays;

public class SimpleGridMinimizer
extends GeneticAlgorithmImpl
implements UnconstrainedMinimizer,
IterativeAlgorithm {
    public IterativeState state;
    public final SimpleCellFactory factory;

    public SimpleGridMinimizer(boolean parallel) {
        this(new SimpleCellFactory(0.1, new UniformRng()), parallel, new UniformRng());
    }

    @Override
    public void step() {
        ++this.state.iteration;
        super.step();
        SimpleCellFactory.SimpleCell a2 = (SimpleCellFactory.SimpleCell)this.getBest(0);
        this.state.xmin = new DenseVector(a2.x());
        this.state.fmin = this.getBest(0).fitness();
    }

    public void solve(RealScalarFunction f2, double tol, int maxIterations, int nStableIterations) {
        this.state = new IterativeState(f2, tol, maxIterations, nStableIterations);
    }

    @Override
    public IterativeState getStates() {
        return this.state.deepCopy();
    }

    public SimpleGridMinimizer(SimpleCellFactory factory, boolean parallel, RandomLongGenerator uniform) {
        super(parallel, uniform);
        this.factory = factory;
    }

    @Override
    public void solve(RealScalarFunction f2, double tol, int maxIterations) {
        this.state = new IterativeState(f2, tol, maxIterations, 10);
    }

    @Override
    public ArrayList<Chromosome> initialization() {
        int a2;
        int a3;
        int a4 = this.state.f.dimensionOfDomain();
        Vector[] a5 = this.state.E;
        if (this.state.E.length == 1) {
            Vector[] vectorArray = new Vector[3];
            a5 = vectorArray;
            vectorArray[0] = this.state.E[0];
            a5[1] = this.state.E[0].scaled(0.5);
            a5[2] = this.state.E[0].scaled(1.5);
        }
        DoubleInterval[] a6 = new DoubleInterval[a4];
        int n = a3 = 0;
        while (n < a4) {
            double a7 = Double.POSITIVE_INFINITY;
            double a8 = Double.NEGATIVE_INFINITY;
            int n2 = a2 = 0;
            while (n2 < a5.length) {
                if (a5[a2].get(a3 + 1) < a7) {
                    a7 = a5[a2].get(a3 + 1);
                }
                if (a5[a2].get(a3 + 1) > a8) {
                    a8 = a5[a2].get(a3 + 1);
                }
                n2 = ++a2;
            }
            a6[a3] = new DoubleInterval(a7, a8);
            n = ++a3;
        }
        a3 = Runtime.getRuntime().availableProcessors();
        int a9 = (int)Math.exp(Math.log(a3) / (double)a4) + 1;
        a9 = Math.max(a9, 4);
        Vector[] a10 = new UniformDistributionOverBox2(0.1, a6, a9, this.uniform).getInitials();
        ArrayList<Chromosome> a11 = new ArrayList<Chromosome>(a10.length);
        int n3 = a2 = 0;
        while (n3 < a10.length) {
            a11.add(this.factory.getSimpleCell(this.state.f, a10[a2].toArray()));
            n3 = ++a2;
        }
        return a11;
    }

    @Override
    public Vector search(Vector ... initials) {
        IterativeState.access$002(this.state, initials);
        super.run();
        return this.state.xmin;
    }

    @Override
    public double minimum() {
        return this.state.fmin;
    }

    @Override
    public boolean isConverged() {
        double a2 = this.minimum();
        double a3 = Math.abs(a2 - this.state.fminLast);
        if (a2 < this.state.fminLast) {
            this.state.fminLast = a2;
        }
        this.state.nNoChanges = a3 < this.state.tol * Math.abs(a2) + Constant.EPSILON ? ++this.state.nNoChanges : 0;
        if (this.state.nNoChanges > this.state.nStableIterations) {
            return true;
        }
        if (this.state.iteration > this.state.maxIterations) {
            return true;
        }
        return false;
    }

    public static class IterativeState
    implements IterativeAlgorithm.IterativeState {
        public final double tol;
        public double fminLast = Double.POSITIVE_INFINITY;
        public final RealScalarFunction f;
        public final int maxIterations;
        public Vector xmin;
        public int iteration = 0;
        private Vector[] E;
        public final int nStableIterations;
        public double fmin = Double.POSITIVE_INFINITY;
        public int nNoChanges = 0;

        @Override
        public IterativeState deepCopy() {
            IterativeState a2 = new IterativeState(this.f, this.tol, this.maxIterations, this.nStableIterations);
            new IterativeState(this.f, this.tol, this.maxIterations, this.nStableIterations).E = Arrays.copyOf(this.E, this.E.length);
            a2.iteration = this.iteration;
            a2.fminLast = this.fminLast;
            a2.fmin = this.fmin;
            a2.xmin = this.xmin.deepCopy();
            return a2;
        }

        public IterativeState(RealScalarFunction f2, double tol, int maxIterations, int nStableIterations) {
            this.f = f2;
            this.tol = tol;
            this.maxIterations = maxIterations;
            this.nStableIterations = nStableIterations;
        }

        @Override
        public int getIteration() {
            return this.iteration;
        }

        public static /* synthetic */ Vector[] access$002(IterativeState a2, Vector[] a3) {
            a2.E = a3;
            return a3;
        }
    }
}

