/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.geneticalgorithm.minimizer;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.optimization.geneticalgorithm.Chromosome;
import com.numericalmethod.suanshu.optimization.geneticalgorithm.minimizer.RealScalarFunctionChromosome;
import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;
import java.util.Arrays;

public class SimpleCellFactory {
    public final RandomLongGenerator uniform;
    private final double E;

    public SimpleCell getSimpleCell(RealScalarFunction f2, double[] x) {
        return new SimpleCell(f2, x);
    }

    public SimpleCellFactory(double rate, RandomLongGenerator uniform) {
        this.E = rate;
        this.uniform = uniform;
    }

    public class SimpleCell
    extends RealScalarFunctionChromosome {
        @Override
        public Chromosome mutate() {
            int a2;
            double a3 = 1.0 - SimpleCellFactory.this.E;
            double a4 = 2.0 * SimpleCellFactory.this.E;
            double[] a5 = Arrays.copyOf(this.x, this.x.length);
            int n = a2 = 0;
            while (n < a5.length) {
                int n2 = a2++;
                a5[n2] = a5[n2] * (a3 + SimpleCellFactory.this.uniform.nextDouble() * a4);
                n = a2;
            }
            return SimpleCellFactory.this.getSimpleCell(this.f, a5);
        }

        public SimpleCell(RealScalarFunction f2, double[] x) {
            super(f2, x);
        }

        @Override
        public Chromosome crossover(Chromosome obj) {
            int a2;
            SimpleCell a3 = (SimpleCell)obj;
            double[] a4 = Arrays.copyOf(this.x, this.x.length);
            int n = a2 = 0;
            while (n < a4.length) {
                a4[a2] = this.x[a2] + a3.x[a2];
                int n2 = a2++;
                a4[n2] = a4[n2] / 2.0;
                n = a2;
            }
            return SimpleCellFactory.this.getSimpleCell(this.f, a4);
        }

        public double[] x() {
            return Arrays.copyOf(this.x, this.x.length);
        }
    }
}

