/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.geneticalgorithm.minimizer;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.optimization.geneticalgorithm.minimizer.SimpleCellFactory;
import com.numericalmethod.suanshu.optimization.unconstrained.UnconstrainedMinimizer;
import com.numericalmethod.suanshu.optimization.unconstrained.UnconstrainedMinimizerFactory;
import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class LocalSearchCellFactory
extends SimpleCellFactory {
    private final UnconstrainedMinimizerFactory L;
    private final double E;

    @Override
    public LocalSearchCell getSimpleCell(RealScalarFunction f2, double[] x) {
        return new LocalSearchCell(f2, x);
    }

    public LocalSearchCellFactory(UnconstrainedMinimizerFactory factory, double tol, RandomLongGenerator uniform) {
        super(0.1, uniform);
        this.L = factory;
        this.E = tol;
    }

    public class LocalSearchCell
    extends SimpleCellFactory.SimpleCell {
        public LocalSearchCell(RealScalarFunction f2, double[] x) {
            super(f2, x);
        }

        @Override
        public LocalSearchCell mutate() {
            UnconstrainedMinimizer a2 = LocalSearchCellFactory.this.L.newInstance();
            a2.solve(this.f, LocalSearchCellFactory.this.E, 500);
            Vector[] vectorArray = new Vector[1];
            vectorArray[0] = new DenseVector(this.x);
            Vector a3 = a2.search(vectorArray);
            return LocalSearchCellFactory.this.getSimpleCell(this.f, a3.toArray());
        }
    }
}

