/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.geneticalgorithm;

import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.optimization.geneticalgorithm.Chromosome;
import com.numericalmethod.suanshu.parallel.LoopBody;
import com.numericalmethod.suanshu.parallel.ParallelExecutor;
import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.RandomNumberGeneratorUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class GeneticAlgorithmImpl {
    public final ParallelExecutor parallel;
    public final ArrayList<Chromosome> population = new ArrayList();
    public final RandomLongGenerator uniform;

    public Chromosome getChild(int i2) {
        Chromosome a2 = this.getOne();
        Chromosome a3 = this.getOne();
        Chromosome a4 = a2.crossover(a3).mutate();
        return a4;
    }

    public GeneticAlgorithmImpl(boolean parallel, RandomLongGenerator uniform) {
        this.parallel = parallel ? new ParallelExecutor() : null;
        this.uniform = parallel ? RandomNumberGeneratorUtils.synchronizedRLG(uniform) : uniform;
    }

    public int nChildren() {
        return this.nPopulation();
    }

    public abstract ArrayList<Chromosome> initialization();

    public Chromosome getOne() {
        int a2 = (int)((double)this.nPopulation() * this.uniform.nextDouble());
        return this.getBest(a2);
    }

    public abstract boolean isConverged();

    public Chromosome getBest(int i2) {
        return this.population.get(i2);
    }

    public void step() {
        final ArrayList<Chromosome> a2 = GeneticAlgorithmImpl.getNewPool(this.nChildren());
        if (this.parallel != null) {
            try {
                this.parallel.forLoop(0, a2.size(), new LoopBody(){
                    {
                        1 a22;
                    }

                    @Override
                    public void run(int i2) throws Exception {
                        Chromosome a22 = GeneticAlgorithmImpl.this.getChild(i2);
                        a22.fitness();
                        a2.set(i2, a22);
                    }
                });
            }
            catch (Exception a3) {
                throw new RuntimeException("failed to generate children", a3);
            }
        } else {
            int a4;
            int n = a4 = 0;
            while (n < a2.size()) {
                a2.set(a4, this.getChild(a4));
                n = ++a4;
            }
        }
        List<Chromosome> a5 = this.getNextGeneration(this.population, a2);
        this.population.clear();
        this.population.addAll(a5);
    }

    public void run() {
        this.population.addAll(this.initialization());
        GeneticAlgorithmImpl geneticAlgorithmImpl = this;
        while (!geneticAlgorithmImpl.isConverged()) {
            this.step();
            geneticAlgorithmImpl = this;
        }
    }

    public List<Chromosome> getNextGeneration(List<Chromosome> parents, List<Chromosome> children) {
        int a2;
        int a3 = parents.size() + children.size();
        ArrayList<Chromosome> a4 = new ArrayList<Chromosome>(a3);
        int n = a2 = 0;
        while (n < parents.size()) {
            a4.add(parents.get(a2));
            n = ++a2;
        }
        int n2 = a2 = 0;
        while (n2 < children.size()) {
            a4.add(children.get(a2));
            n2 = ++a2;
        }
        Collections.sort(a4);
        List<Chromosome> a22 = a4.subList(0, this.nChildren());
        return a22;
    }

    static {
        Package.getInstance("OPTIM").isValidated();
    }

    public int nPopulation() {
        return this.population.size();
    }

    public static ArrayList<Chromosome> getNewPool(int size) {
        return new ArrayList<Object>(Collections.nCopies(size, null));
    }
}

