/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.sqp.activeset.equalityconstraint;

import com.numericalmethod.suanshu.analysis.differentiation.multivariate.Gradient;
import com.numericalmethod.suanshu.analysis.differentiation.multivariate.Jacobian;
import com.numericalmethod.suanshu.analysis.function.rn2r1.QuadraticFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.optimization.constrained.constraint.EqualityConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearEqualityConstraints;
import com.numericalmethod.suanshu.optimization.constrained.convex.quadraticprogramming.QPInfeasible;
import com.numericalmethod.suanshu.optimization.constrained.convex.quadraticprogramming.QPSolution;
import com.numericalmethod.suanshu.optimization.constrained.convex.quadraticprogramming.SimpleQPSolver;
import com.numericalmethod.suanshu.optimization.constrained.general.ConstrainedMinimizer;
import com.numericalmethod.suanshu.optimization.constrained.general.ConstrainedOptimProblem;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.ArrayList;

public class SQPActiveSetSolverForOnlyEqualityConstraint1
implements ConstrainedMinimizer {
    private final Implementation L;
    private State E;

    public SQPActiveSetSolverForOnlyEqualityConstraint1(Implementation impl) {
        this.L = impl;
    }

    @Override
    public void solve(ConstrainedOptimProblem problem, double epsilon, int maxIterations) {
        EqualityConstraints a2 = problem.getEqualityConstraints();
        SuanShuUtils.assertArgument(a2 != null, "there must be equality constraints", new Object[0]);
        SuanShuUtils.assertArgument(problem.getLessThanConstraints() == null, "there must be only equality constraints", new Object[0]);
        this.solve(problem.f(), a2, epsilon, maxIterations);
    }

    @Override
    public double minimum() {
        return this.E.f.evaluate(this.E.x0.toArray());
    }

    public void solve(RealScalarFunction f2, EqualityConstraints equal, double epsilon, int maxIterations) {
        this.E = new State(f2, equal, epsilon, maxIterations, null);
        this.L.set(f2, equal);
    }

    public static Vector v1(Matrix W, Vector g2, Matrix A, Vector d2) {
        Vector a2 = W.multiply(d2).add(g2);
        a2 = A.multiply(a2);
        Matrix a3 = A.multiply(A.t());
        a2 = new Inverse(a3, 0.0).multiply(a2);
        return a2;
    }

    @Override
    public Vector search(Vector ... initials) {
        int a2;
        this.E.x0 = initials[0];
        this.E.v0 = initials[1];
        this.E.W0 = this.L.getInitialHessian(this.E.x0, this.E.v0);
        int n = a2 = 0;
        while (n < this.E.maxIterations) {
            Matrix a3;
            Object a4;
            int a5;
            double[] a6 = this.E.x0.toArray();
            this.E.g0 = new Gradient(this.E.f, a6);
            this.E.A0 = new Jacobian(this.E.a, a6);
            DenseVector a7 = new DenseVector(this.E.p);
            int n2 = a5 = 0;
            while (n2 < this.E.p) {
                a7.set(a5 + 1, this.E.a.get(a5).evaluate(a6));
                n2 = ++a5;
            }
            try {
                a4 = new QuadraticFunction(this.E.W0, this.E.g0);
                LinearEqualityConstraints a8 = new LinearEqualityConstraints(this.E.A0, a7.scaled(-1.0));
                QPSolution a9 = SimpleQPSolver.solve((QuadraticFunction)a4, a8, 0.0);
                this.E.d = a9.minimizer();
            }
            catch (QPInfeasible a10) {
                Object[] objectArray = new Object[1];
                objectArray[0] = a10.getMessage();
                throw new RuntimeException(String.format("unable to solve a sub quadratic programming problem: ", objectArray));
            }
            a4 = SQPActiveSetSolverForOnlyEqualityConstraint1.v1(this.E.W0, this.E.g0, this.E.A0, this.E.d);
            double a11 = this.L.alpha(this.E.x0, this.E.d, (Vector)a4);
            this.E.d = this.E.d.scaled(a11);
            Vector a12 = this.E.x0.add(this.E.d);
            a4 = SQPActiveSetSolverForOnlyEqualityConstraint1.v1(this.E.W0, this.E.g0, this.E.A0, this.E.d);
            this.E.x0 = a12;
            this.E.v0 = a4;
            if (this.E.d.norm() < this.E.epsilon) break;
            this.E.W0 = a3 = this.L.updateHessian(a12, (Vector)a4, this.E.d, this.E.g0, this.E.A0, this.E.W0);
            n = ++a2;
        }
        return this.E.x0;
    }

    public static class 1 {
    }

    private static class State {
        public Vector g0;
        public Matrix A0;
        public Matrix W0;
        public final ArrayList<RealScalarFunction> a;
        public final int p;
        public final double epsilon;
        public Vector x0;
        public final int maxIterations;
        public final RealScalarFunction f;
        public final EqualityConstraints equal;
        public Vector d;
        public Vector v0;

        private State(RealScalarFunction a2, EqualityConstraints a3, double a4, int a5) {
            State a6;
            a6.f = a2;
            a6.equal = a3;
            a6.epsilon = a4;
            a6.maxIterations = a5;
            a6.a = a3.getConstraints();
            a6.p = a6.a.size();
        }

        public /* synthetic */ State(RealScalarFunction a2, EqualityConstraints a3, double a4, int a5, 1 a6) {
            a7(a2, a3, a4, a5);
            State a7;
        }
    }

    public static interface Implementation
    extends com.numericalmethod.suanshu.optimization.constrained.sqp.activeset.equalityconstraint.Implementation {
        public void set(RealScalarFunction var1, EqualityConstraints var2);
    }
}

