/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.sqp.activeset.equalityconstraint;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.differentiation.multivariate.Gradient;
import com.numericalmethod.suanshu.analysis.differentiation.multivariate.Hessian;
import com.numericalmethod.suanshu.analysis.differentiation.multivariate.Jacobian;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.matrix.doubles.IsMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.Eigen;
import com.numericalmethod.suanshu.matrix.doubles.operation.positivedefinite.PositiveDefiniteMatrixBySmallDiagonalElements;
import com.numericalmethod.suanshu.number.DoubleArrayMath;
import com.numericalmethod.suanshu.optimization.constrained.constraint.EqualityConstraints;
import com.numericalmethod.suanshu.optimization.constrained.sqp.activeset.equalityconstraint.SQPActiveSetSolverForOnlyEqualityConstraint1;
import com.numericalmethod.suanshu.optimization.unconstrained.quasinewton.BFGS;
import com.numericalmethod.suanshu.optimization.univariate.GridSearch;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import java.util.ArrayList;

public class Implementation1
implements SQPActiveSetSolverForOnlyEqualityConstraint1.Implementation {
    public RealScalarFunction f;
    public ArrayList<RealScalarFunction> a;
    public int p;
    public final double epsilon = Math.sqrt(Constant.EPSILON);
    public final double lower;
    public boolean foundPositiveDefiniteHessian = false;
    public final double r;
    public final int discretization;

    public Implementation1() {
        this(100.0, 0.01, 50);
    }

    public Implementation1(double r2, double lower, int discretization) {
        this.r = r2;
        this.lower = lower;
        this.discretization = discretization;
    }

    @Override
    public double alpha(final Vector x, final Vector d2, Vector v) {
        UnivariateRealFunction a2 = new UnivariateRealFunction(){
            {
                1 a2;
            }

            @Override
            public double evaluate(double alpha) {
                int a2;
                Vector a3 = x.add(d2.scaled(alpha));
                double a4 = Implementation1.this.f.evaluate(a3.toArray());
                int n = a2 = 0;
                while (n < Implementation1.this.p) {
                    double a5 = Implementation1.this.a.get(a2).evaluate(a3.toArray());
                    a4 += Math.abs(Implementation1.this.r * a5);
                    n = ++a2;
                }
                return a4;
            }
        };
        GridSearch a3 = new GridSearch();
        a3.solve(a2, this.epsilon, this.discretization);
        return a3.search(this.lower, 1.0);
    }

    @Override
    public void set(RealScalarFunction f2, EqualityConstraints equal) {
        this.f = f2;
        this.a = equal.getConstraints();
        this.p = this.a.size();
    }

    public Matrix W(Vector x, Vector u) {
        int a2;
        Matrix a3 = new Hessian(this.f, x);
        int n = a2 = 0;
        while (n < this.p) {
            double a4 = u.get(a2 + 1);
            RealScalarFunction a5 = this.a.get(a2);
            Hessian a6 = new Hessian(a5, x);
            a3 = a3.minus(a6.scaled(a4));
            n = ++a2;
        }
        return a3;
    }

    @Override
    public Matrix updateHessian(Vector x1, Vector v1, Vector d2, Vector g0, Matrix A0, Matrix W0) {
        Vector a2 = new Gradient(this.f, x1).minus(g0);
        Jacobian a3 = new Jacobian(this.a, x1.toArray());
        Matrix a4 = a3.minus(A0);
        Vector a5 = a4.t().multiply(v1);
        Vector a6 = a2.minus(a5);
        Matrix a7 = BFGS.dampedBFGSHessianUpdate(W0, a6, d2);
        a7 = new PositiveDefiniteMatrixBySmallDiagonalElements(a7, this.epsilon, Constant.EPSILON);
        return a7;
    }

    @Override
    public Matrix getInitialHessian(Vector x0, Vector v0) {
        Matrix a2 = this.W(x0, v0);
        if (IsMatrix.positiveDefinite(a2)) {
            this.foundPositiveDefiniteHessian = true;
            return a2;
        }
        double[] a3 = new Eigen(a2).getRealEigenvalues();
        double a4 = DoubleArrayMath.max(a3);
        if (a4 < 0.0) {
            return a2.ONE();
        }
        a2 = new PositiveDefiniteMatrixBySmallDiagonalElements(a2, this.epsilon, Constant.EPSILON);
        return a2;
    }
}

