/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.sqp.activeset;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.differentiation.multivariate.Gradient;
import com.numericalmethod.suanshu.analysis.differentiation.multivariate.Jacobian;
import com.numericalmethod.suanshu.analysis.function.rn2r1.QuadraticFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleArrayMath;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.constrained.constraint.EqualityConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.GreaterThanConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearEqualityConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearGreaterThanConstraints;
import com.numericalmethod.suanshu.optimization.constrained.convex.quadraticprogramming.QPInfeasible;
import com.numericalmethod.suanshu.optimization.constrained.convex.quadraticprogramming.problem.StandardQPProblem1;
import com.numericalmethod.suanshu.optimization.constrained.convex.quadraticprogramming.solver.activeset.QPPrimalActiveSetSolver;
import com.numericalmethod.suanshu.optimization.constrained.general.ConstrainedMinimizer;
import com.numericalmethod.suanshu.optimization.constrained.general.ConstrainedOptimProblem;
import com.numericalmethod.suanshu.optimization.constrained.sqp.activeset.Implementation1;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;
import java.util.ArrayList;
import java.util.Collection;

public class SQPActiveSetSolver
implements ConstrainedMinimizer {
    private final Implementation L;
    private State E;

    public SQPActiveSetSolver() {
        this(new Implementation1(Math.sqrt(Constant.EPSILON)));
    }

    public SQPActiveSetSolver(Implementation impl) {
        this.L = impl;
    }

    @Override
    public double minimum() {
        return this.E.f.evaluate(this.E.x0.toArray());
    }

    @Override
    public Vector search(Vector ... initials) {
        int a2;
        this.E.x0 = initials[0];
        this.E.v0 = initials[1];
        this.E.u0 = initials[2];
        this.E.Z0 = this.L.getInitialHessian(this.E.x0, this.E.v0, this.E.u0);
        SuanShuUtils.assertArgument(DoubleArrayMath.min(this.E.u0.toArray()) >= 0.0, "mu[0] must be >= 0", new Object[0]);
        int n = a2 = 0;
        while (n < this.E.maxIterations) {
            Matrix a3;
            Vector a4;
            int a5;
            int a6;
            Object a7;
            Object a8;
            Object a9;
            Object a10;
            Object a32;
            Object a11;
            int a12;
            int a13;
            double[] a14 = this.E.x0.toArray();
            this.E.g0 = new Gradient(this.E.f, a14);
            this.E.Ae0 = this.E.equal != null ? new Jacobian(this.E.a, a14) : new DenseMatrix(0, 0);
            this.E.Ai0 = new Jacobian(this.E.c, a14);
            DenseVector a15 = new DenseVector(this.E.p);
            int n2 = a13 = 0;
            while (n2 < this.E.p) {
                a15.set(a13 + 1, this.E.a.get(a13).evaluate(a14));
                n2 = ++a13;
            }
            DenseVector a22 = new DenseVector(this.E.q);
            int n3 = a12 = 0;
            while (n3 < this.E.q) {
                a22.set(a12 + 1, this.E.c.get(a12).evaluate(a14));
                n3 = ++a12;
            }
            try {
                a11 = new QuadraticFunction(this.E.Z0, this.E.g0);
                a32 = this.E.equal != null ? new LinearEqualityConstraints(this.E.Ae0, a15.scaled(-1.0)) : null;
                a10 = new LinearGreaterThanConstraints(this.E.Ai0, a22.scaled(-1.0));
                a9 = new StandardQPProblem1((QuadraticFunction)a11, (LinearEqualityConstraints)a32, (LinearGreaterThanConstraints)a10);
                a8 = new QPPrimalActiveSetSolver();
                ((QPPrimalActiveSetSolver)a8).solve((StandardQPProblem1)a9);
                a7 = ((QPPrimalActiveSetSolver)a8).search();
                this.E.d = a7.minimizer();
            }
            catch (QPInfeasible a16) {
                Object[] objectArray = new Object[1];
                objectArray[0] = a16.getMessage();
                throw new RuntimeException(String.format("unable to solve a sub quadratic programming problem: ", objectArray));
            }
            a11 = new ArrayList();
            int n4 = a6 = 1;
            while (n4 <= this.E.Ai0.nRows()) {
                double d2;
                a10 = this.E.Ai0.getRow(a6);
                double a17 = a10.innerProduct(this.E.d);
                if (Math.abs(d2 + a22.get(a6)) < this.E.epsilon) {
                    ((ArrayList)a11).add(a6);
                }
                n4 = ++a6;
            }
            a32 = DoubleUtils.Collection2intArray((Collection<Integer>)a11);
            a10 = R.seq(1, this.E.Ai0.nCols());
            a9 = CreateMatrix.subMatrix(this.E.Ai0, (int[])a32, (int[])a10);
            Matrix[] matrixArray = new Matrix[2];
            matrixArray[0] = this.E.Ae0;
            matrixArray[1] = a9;
            a8 = CreateMatrix.rbind(matrixArray);
            a7 = a8.multiply(a8.t());
            a7 = new Inverse((Matrix)a7);
            a7 = a7.multiply((Matrix)a8);
            Vector a18 = this.E.Z0.multiply(this.E.d);
            a18 = a18.add(this.E.g0);
            Vector a19 = a7.multiply(a18);
            Vector a20 = CreateVector.subVector(a19, 1, this.E.p);
            Vector a21 = CreateVector.subVector(a19, this.E.p + 1, a19.size());
            DenseVector a23 = new DenseVector(this.E.q);
            int n5 = a5 = 0;
            while (n5 < ((Object)a32).length) {
                Object a24 = a32[a5];
                a23.set((int)a24, a21.get(a5 + 1));
                n5 = ++a5;
            }
            double a42 = this.L.alpha(this.E.x0, this.E.d, a20, a23);
            this.E.d = this.E.d.scaled(a42);
            this.E.x0 = a4 = this.E.x0.add(this.E.d);
            this.E.v0 = a20;
            this.E.u0 = a23;
            if (this.E.d.norm() < this.E.epsilon) break;
            this.E.Z0 = a3 = this.L.updateHessian(a4, a20, a23, this.E.d, this.E.g0, this.E.Ae0, this.E.Ai0, this.E.Z0);
            n = ++a2;
        }
        return this.E.x0;
    }

    @Override
    public void solve(ConstrainedOptimProblem problem, double epsilon, int maxIterations) {
        this.E = new State(problem.f(), problem.getEqualityConstraints(), problem.getLessThanConstraints().toGreaterThanConstraints(), epsilon, maxIterations, null);
        this.L.set(this.E.f, this.E.equal, this.E.greater);
    }

    public static class 1 {
    }

    private static class State {
        public final ArrayList<RealScalarFunction> c;
        public Vector x0;
        public final int p;
        public Vector d;
        public final ArrayList<RealScalarFunction> a;
        public final RealScalarFunction f;
        public final int maxIterations;
        public Vector g0;
        public Vector u0;
        public Matrix Z0;
        public final EqualityConstraints equal;
        public final int q;
        public Matrix Ai0;
        public Vector v0;
        public Matrix Ae0;
        public final GreaterThanConstraints greater;
        public final double epsilon;

        private State(RealScalarFunction a2, EqualityConstraints a3, GreaterThanConstraints a4, double a5, int a6) {
            State a7;
            a7.f = a2;
            a7.epsilon = a5;
            a7.maxIterations = a6;
            a7.equal = a3;
            a7.a = a3 != null ? a3.getConstraints() : new ArrayList(0);
            a7.p = a7.a.size();
            a7.greater = a4;
            a7.c = a4.getConstraints();
            a7.q = a7.c.size();
        }

        public /* synthetic */ State(RealScalarFunction a2, EqualityConstraints a3, GreaterThanConstraints a4, double a5, int a6, 1 a7) {
            a8(a2, a3, a4, a5, a6);
            State a8;
        }
    }

    public static interface Implementation
    extends com.numericalmethod.suanshu.optimization.constrained.sqp.activeset.Implementation {
        public void set(RealScalarFunction var1, EqualityConstraints var2, GreaterThanConstraints var3);
    }
}

