/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.sqp.activeset;

import com.numericalmethod.suanshu.analysis.differentiation.multivariate.Gradient;
import com.numericalmethod.suanshu.analysis.differentiation.multivariate.Jacobian;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.positivedefinite.PositiveDefiniteMatrixBySmallDiagonalElements;
import com.numericalmethod.suanshu.optimization.constrained.constraint.EqualityConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.GreaterThanConstraints;
import com.numericalmethod.suanshu.optimization.constrained.sqp.activeset.SQPActiveSetSolver;
import com.numericalmethod.suanshu.optimization.unconstrained.quasinewton.BFGS;
import com.numericalmethod.suanshu.optimization.univariate.GridSearch;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.ArrayList;

public class Implementation1
implements SQPActiveSetSolver.Implementation {
    public ArrayList<RealScalarFunction> ag;
    public RealScalarFunction f;
    public final double epsilon;
    public ArrayList<RealScalarFunction> ae;

    @Override
    public void set(RealScalarFunction f2, EqualityConstraints equal, GreaterThanConstraints greater) {
        this.f = f2;
        this.ae = equal != null ? equal.getConstraints() : new ArrayList(0);
        this.ag = greater.getConstraints();
    }

    @Override
    public double alpha(final Vector x, final Vector d2, Vector v, final Vector u) {
        final int a2 = this.ae.size();
        final int a3 = this.ag.size();
        double a4 = 100.0;
        UnivariateRealFunction a5 = new UnivariateRealFunction(){
            {
                1 a22;
            }

            @Override
            public double evaluate(double alpha) {
                double a22;
                int a32;
                Vector a4 = x.add(d2.scaled(alpha));
                double a5 = Implementation1.this.f.evaluate(a4.toArray());
                int n = a32 = 0;
                while (n < a2) {
                    a22 = Implementation1.this.ae.get(a32).evaluate(a4.toArray());
                    a5 += 100.0 * a22 * a22;
                    n = ++a32;
                }
                int n2 = a32 = 0;
                while (n2 < a3) {
                    a22 = Implementation1.this.ag.get(a32).evaluate(a4.toArray());
                    a5 -= u.get(a32 + 1) * a22;
                    n2 = ++a32;
                }
                return a5;
            }
        };
        GridSearch a6 = new GridSearch();
        a6.solve(a5, this.epsilon, 50);
        return a6.search(0.001, 1.0);
    }

    public Implementation1(double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public Matrix getInitialHessian(Vector x0, Vector v0, Vector u0) {
        return new DenseMatrix(this.f.dimensionOfDomain(), this.f.dimensionOfDomain()).ONE();
    }

    @Override
    public Matrix updateHessian(Vector x1, Vector v1, Vector u1, Vector d2, Vector g0, Matrix Ae0, Matrix Ai0, Matrix Z0) {
        Matrix a2;
        Jacobian a3;
        Vector a4 = new Gradient(this.f, x1).minus(g0);
        Vector a5 = new DenseVector(a4.size(), 0.0);
        if (!this.ae.isEmpty()) {
            a3 = new Jacobian(this.ae, x1.toArray());
            a2 = a3.minus(Ae0);
            a5 = a2.t().multiply(v1);
        }
        a3 = new Jacobian(this.ag, x1.toArray());
        a2 = a3.minus(Ai0);
        Vector a6 = a2.t().multiply(u1);
        Vector a7 = a4.minus(a5).minus(a6);
        Matrix a8 = BFGS.dampedBFGSHessianUpdate(Z0, a7, d2);
        a8 = new PositiveDefiniteMatrixBySmallDiagonalElements(a8, this.epsilon, this.epsilon);
        return a8;
    }
}

