/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.solver;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.SimplexTable;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.solver.LPSimplexSolution;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class LPUnboundedSolution
implements LPSimplexSolution {
    public final SimplexTable table;
    public final int lambdaCol;

    @Override
    public double min() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public SimplexTable getResultantTableau() {
        return new SimplexTable(this.table);
    }

    public LPUnboundedSolution(SimplexTable table, int lambdaCol) {
        Object[] objectArray = new Object[1];
        objectArray[0] = lambdaCol;
        SuanShuUtils.assertArgument(lambdaCol > 0, "this class reads only an unbounded solution, lambdaCol = %d", objectArray);
        this.lambdaCol = lambdaCol;
        this.table = new SimplexTable(table);
    }

    public ImmutableVector v() {
        int a2;
        DenseVector a3 = new DenseVector(this.table.getProblemSize(), 0.0);
        a3.set(this.table.getColLabel((int)this.lambdaCol).index, 1.0);
        int n = a2 = 1;
        while (n < this.table.nRows()) {
            if (this.table.getRowLabel((int)a2).type == SimplexTable.LabelType.NON_BASIC) {
                a3.set(this.table.getRowLabel((int)a2).index, this.table.get(a2, this.lambdaCol));
            }
            n = ++a2;
        }
        return new ImmutableVector(a3);
    }

    @Override
    public ImmutableVector minimizer() {
        return this.table.minimizer();
    }
}

