/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.solver;

import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.exception.LPInfeasible;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.exception.LPUnbounded;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.problem.GeneralLPProblem;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.Phase1ByFerrisMangasarianWright;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.Scheme2ByFerrisMangasarianWright;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.SimplexTable;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.solver.CanonicalLPSolver;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.solver.LPSimplexSolution;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.solver.LPSimplexSolver;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.solver.LPUnboundedSolutionScheme2;

public class GeneralLPSolver
implements LPSimplexSolver {
    private LPSimplexSolver E;

    public GeneralLPSolver(LPSimplexSolver solver) {
        this.E = solver;
    }

    public GeneralLPSolver() {
        this(new CanonicalLPSolver());
    }

    @Override
    public LPSimplexSolution solve(SimplexTable table) throws LPInfeasible {
        Object a2;
        try {
            a2 = new Scheme2ByFerrisMangasarianWright(table);
            table = ((Scheme2ByFerrisMangasarianWright)a2).process();
        }
        catch (LPUnbounded a3) {
            return new LPUnboundedSolutionScheme2(table, a3.s);
        }
        if (!table.isFeasible()) {
            a2 = new Phase1ByFerrisMangasarianWright(table);
            table = ((Phase1ByFerrisMangasarianWright)a2).process();
        }
        return this.E.solve(table);
    }

    public LPSimplexSolution solve(GeneralLPProblem problem) throws LPInfeasible {
        SimplexTable a2 = new SimplexTable(problem);
        return this.solve(a2);
    }
}

