/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.pivoting;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.exception.LPUnbounded;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.SimplexTable;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.pivoting.SimplexPivoting;

public class NaiveRule
implements SimplexPivoting {
    @Override
    public int pricing(SimplexTable table) {
        int a2;
        int a3 = 0;
        int n = a2 = 1;
        while (n < table.nCols()) {
            if ((table.getColLabel((int)a2).type == SimplexTable.LabelType.NON_BASIC || table.getColLabel((int)a2).type == SimplexTable.LabelType.BASIC || table.getColLabel((int)a2).type == SimplexTable.LabelType.FREE) && table.getCostRow(a2) < 0.0) {
                a3 = a3 == 0 ? a2 : (table.getCostRow(a2) < table.getCostRow(a3) ? a2 : a3);
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public SimplexPivoting.Pivot getPivot(SimplexTable table) throws LPUnbounded {
        int a2 = this.pricing(table);
        if (a2 == 0) {
            return null;
        }
        int a3 = this.ratioTest(table, a2);
        if (a3 == 0) {
            throw new LPUnbounded(a2);
        }
        return new SimplexPivoting.Pivot(a3, a2);
    }

    @Override
    public int ratioTest(SimplexTable table, int s2) {
        int a2;
        int a3 = 0;
        double a4 = Double.MAX_VALUE;
        int n = a2 = 1;
        while (n < table.nRows()) {
            if (table.getRowLabel((int)a2).type == SimplexTable.LabelType.BASIC || table.getRowLabel((int)a2).type == SimplexTable.LabelType.NON_BASIC || table.getRowLabel((int)a2).type == SimplexTable.LabelType.ARTIFICIAL) {
                double d2;
                double a5 = table.get(a2, s2);
                if (!(d2 >= 0.0)) {
                    double a6 = -table.getBCol(a2) / a5;
                    double[] dArray = new double[1];
                    dArray[0] = a6;
                    double a7 = SuanShuUtils.autoEpsilon(dArray);
                    if (a6 < a4 - a7 || DoubleUtils.compare(a6, a4, a7) == 0 && table.getRowLabel((int)a2).index < table.getRowLabel((int)a3).index) {
                        a4 = a6;
                        a3 = a2;
                    }
                }
            }
            n = ++a2;
        }
        return a3;
    }
}

