/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.integer;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.optimization.constrained.constraint.EqualityConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.LessThanConstraints;
import com.numericalmethod.suanshu.optimization.constrained.general.ConstrainedOptimProblem;
import java.util.Arrays;

public class IntegerConstrainedOptimProblem
extends ConstrainedOptimProblem {
    private IntegralConstraint[] E;

    public IntegerConstrainedOptimProblem(RealScalarFunction f2, EqualityConstraints equal, LessThanConstraints less, IntegralConstraint ... integers) {
        super(f2, equal, less);
        this.E = Arrays.copyOf(integers, integers.length);
    }

    public IntegralConstraint getIntegralConstraint(int index) {
        int a2;
        int n = a2 = 0;
        while (n < this.E.length) {
            if (this.E[a2].index == index) {
                return this.E[a2];
            }
            n = ++a2;
        }
        Object[] objectArray = new Object[1];
        objectArray[0] = index;
        throw new RuntimeException(String.format("no corresponding integer constraint for the index variable %d", objectArray));
    }

    public int[] getIntegerIndices() {
        int a2;
        int[] a3 = new int[this.E.length];
        int n = a2 = 0;
        while (n < this.E.length) {
            a3[a2] = this.E[a2].index;
            n = ++a2;
        }
        return a3;
    }

    public static class IntegralConstraint {
        public final int index;
        public final int[] domain;

        public IntegralConstraint(int index, int[] domain) {
            this.index = index;
            this.domain = Arrays.copyOf(domain, domain.length);
        }

        public IntegralConstraint(int index, int lower, int upper, int inc) {
            this(index, R.seq(lower, upper, inc));
        }

        public IntegralConstraint(int index, int lower, int upper) {
            this(index, R.seq(lower, upper));
        }
    }
}

