/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.integer;

import com.numericalmethod.suanshu.algorithm.Combination;
import com.numericalmethod.suanshu.analysis.function.RestrictedFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarRestrictedFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorRestrictedFunction;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.constrained.constraint.ConstraintsUtils;
import com.numericalmethod.suanshu.optimization.constrained.constraint.EqualityConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.GreaterThanConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.LessThanConstraints;
import com.numericalmethod.suanshu.optimization.constrained.general.ConstrainedMinimizer;
import com.numericalmethod.suanshu.optimization.constrained.general.ConstrainedMinimizerFactory;
import com.numericalmethod.suanshu.optimization.constrained.general.ConstrainedOptimProblem;
import com.numericalmethod.suanshu.optimization.constrained.general.penaltymethod.PenaltyMethodMinimizer;
import com.numericalmethod.suanshu.optimization.constrained.integer.IntegerConstrainedMinimizer;
import com.numericalmethod.suanshu.optimization.constrained.integer.IntegerConstrainedOptimProblem;
import com.numericalmethod.suanshu.parallel.IterationBody;
import com.numericalmethod.suanshu.parallel.MultipleExecutionException;
import com.numericalmethod.suanshu.parallel.ParallelExecutor;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class BruteForceMinimizer
implements IntegerConstrainedMinimizer {
    private double G;
    private IntegerConstrainedOptimProblem F;
    private int k;
    private final ConstrainedMinimizerFactory L;
    private double E;

    @Override
    public void solve(IntegerConstrainedOptimProblem problem, double tol, int maxIterations) {
        this.F = problem;
        this.G = tol;
        this.k = maxIterations;
        this.E = Double.POSITIVE_INFINITY;
    }

    @Override
    public double minimum() {
        return this.E;
    }

    public BruteForceMinimizer(ConstrainedMinimizerFactory solverFactory) {
        this.L = solverFactory;
    }

    public BruteForceMinimizer() {
        this(new ConstrainedMinimizerFactory(){
            {
                1 a2;
            }

            @Override
            public ConstrainedMinimizer newInstance() {
                return new PenaltyMethodMinimizer();
            }
        });
    }

    @Override
    public Vector search(final Vector ... initials) {
        Combination<Integer> combination;
        int a2;
        final int[] a3 = this.F.getIntegerIndices();
        Integer[][] a4 = new Integer[a3.length][];
        int n = a2 = 0;
        while (n < a3.length) {
            a4[a2] = DoubleUtils.intArray2ArrayList(this.F.getIntegralConstraint((int)a3[a2]).domain).toArray(new Integer[0]);
            n = ++a2;
        }
        if (a3.length > 0) {
            combination = new Combination<Integer>(a4);
        } else {
            Integer[][] integerArrayArray = new Integer[1][];
            Integer[] integerArray = new Integer[1];
            integerArray[0] = null;
            integerArrayArray[0] = integerArray;
            combination = new Combination<Integer>(integerArrayArray);
        }
        Combination<Integer> a22 = combination;
        final ConcurrentLinkedQueue a5 = new ConcurrentLinkedQueue();
        try {
            new ParallelExecutor().forEach(a22, new IterationBody<List<Integer>>(){

                @Override
                public void run(List<Integer> values) {
                    int a2;
                    final ArrayList<RestrictedFunction.FixedValues> a32 = new ArrayList<RestrictedFunction.FixedValues>(a3.length);
                    int n = a2 = 0;
                    while (n < a3.length) {
                        a32.add(new RestrictedFunction.FixedValues(a3[a2], values.get(a2).intValue()));
                        n = ++a2;
                    }
                    RealScalarRestrictedFunction a22 = new RealScalarRestrictedFunction(BruteForceMinimizer.this.F.f(), a32);
                    int a4 = a22.dimensionOfDomain();
                    EqualityConstraints a52 = null;
                    if (BruteForceMinimizer.this.F.getEqualityConstraints() != null && (a52 = new EqualityConstraints(){
                        private RealVectorRestrictedFunction E;

                        @Override
                        public Vector evaluate(double ... x) {
                            return this.E.evaluate(x);
                        }

                        @Override
                        public int dimensionOfDomain() {
                            return this.E.dimensionOfDomain();
                        }
                        {
                            1 a2;
                            a2.E = new RealVectorRestrictedFunction((RealVectorFunction)a2.BruteForceMinimizer.this.F.getEqualityConstraints(), (Collection<RestrictedFunction.FixedValues>)a2.a32);
                        }

                        @Override
                        public int dimensionOfRange() {
                            return this.E.dimensionOfRange();
                        }

                        @Override
                        public ArrayList<RealScalarFunction> getConstraints() {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }
                    }).dimensionOfDomain() == 0) {
                        if (!ConstraintsUtils.isSatisfied(a52, new double[0])) {
                            return;
                        }
                    }
                    LessThanConstraints a6 = null;
                    if (BruteForceMinimizer.this.F.getLessThanConstraints() != null && (a6 = new LessThanConstraints(){
                        private RealVectorRestrictedFunction E;

                        @Override
                        public GreaterThanConstraints toGreaterThanConstraints() {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }

                        @Override
                        public int dimensionOfRange() {
                            return this.E.dimensionOfRange();
                        }

                        @Override
                        public int dimensionOfDomain() {
                            return this.E.dimensionOfDomain();
                        }
                        {
                            2 a2;
                            a2.E = new RealVectorRestrictedFunction((RealVectorFunction)a2.BruteForceMinimizer.this.F.getLessThanConstraints(), (Collection<RestrictedFunction.FixedValues>)a2.a32);
                        }

                        @Override
                        public ArrayList<RealScalarFunction> getConstraints() {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }

                        @Override
                        public Vector evaluate(double ... x) {
                            return this.E.evaluate(x);
                        }
                    }).dimensionOfDomain() == 0) {
                        if (!ConstraintsUtils.isSatisfied(a6, new double[0])) {
                            return;
                        }
                    }
                    ConstrainedOptimProblem a7 = new ConstrainedOptimProblem(a22, a52, a6);
                    Vector a8 = new DenseVector(0);
                    ConstrainedMinimizer a9 = BruteForceMinimizer.this.L.newInstance();
                    if (a4 > 0) {
                        a9.solve(a7, BruteForceMinimizer.this.G, BruteForceMinimizer.this.k);
                        Vector[] vectorArray = new Vector[1];
                        vectorArray[0] = new DenseVector(a22.getVariablePart(initials[0].toArray()));
                        a8 = a9.search(vectorArray);
                    }
                    double a10 = a22.evaluate(a8.toArray());
                    a5.add(new Result(a10, a8, a32, null));
                }
                {
                    2 a2;
                }
            });
        }
        catch (MultipleExecutionException a6) {
            throw new RuntimeException(a6.getCause());
        }
        Vector a7 = null;
        ArrayList a8 = null;
        for (Result a9 : a5) {
            Result result;
            if (!(result.L < this.E)) continue;
            this.E = a9.L;
            a7 = a9.k;
            a8 = a9.E;
        }
        Object a10 = RealScalarRestrictedFunction.getAllParts(a7.toArray(), a8);
        return new DenseVector((double[])a10);
    }

    private static class Result {
        private final Vector k;
        private final double L;
        private final ArrayList<RestrictedFunction.FixedValues> E;

        private Result(double a2, Vector a3, ArrayList<RestrictedFunction.FixedValues> a4) {
            Result a5;
            a5.L = a2;
            a5.k = a3;
            a5.E = a4;
        }

        public /* synthetic */ Result(double a2, Vector a3, ArrayList a4, 1 a5) {
            a6(a2, a3, a4);
            Result a6;
        }
    }
}

