/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.convex.quadraticprogramming.solver.activeset;

import com.numericalmethod.suanshu.algorithm.IterativeAlgorithm;
import com.numericalmethod.suanshu.analysis.function.rn2r1.QuadraticFunction;
import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.IsMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.linearsystem.LinearSystemSolver;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearEqualityConstraints;
import com.numericalmethod.suanshu.optimization.constrained.convex.quadraticprogramming.QPInfeasible;
import com.numericalmethod.suanshu.optimization.constrained.convex.quadraticprogramming.QPSolution;
import com.numericalmethod.suanshu.optimization.constrained.convex.quadraticprogramming.SimpleQPSolver;
import com.numericalmethod.suanshu.optimization.constrained.convex.quadraticprogramming.problem.StandardQPProblem1;
import com.numericalmethod.suanshu.optimization.constrained.convex.quadraticprogramming.solver.activeset.WorkingActiveSet;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;
import java.util.HashMap;

public class QPPrimalActiveSetSolver
implements IterativeAlgorithm {
    private IterativeState E;

    @Override
    public void step() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QPSolution search(Vector ... initials) throws QPInfeasible {
        Matrix a2 = this.E.problem.f().Hessian();
        Vector a3 = this.E.problem.f().p();
        Vector a4 = initials[0];
        WorkingActiveSet a5 = new WorkingActiveSet(this.E.A);
        a5.addAll(this.E.problem.getGreaterThanConstraints().getActiveRows(a4, this.E.epsilon));
        this.E.E = 0;
        QPPrimalActiveSetSolver qPPrimalActiveSetSolver = this;
        while (qPPrimalActiveSetSolver.E.E < this.E.maxIterations) {
            int a6;
            Object a7;
            Object a8;
            Matrix matrix;
            Vector a9 = a2.multiply(a4).add(a3);
            QuadraticFunction a10 = new QuadraticFunction(a2, a9);
            if (this.E.Aeq != null) {
                Matrix[] matrixArray = new Matrix[2];
                matrixArray[0] = a5.Aa();
                matrixArray[1] = this.E.Aeq;
                matrix = CreateMatrix.rbind(matrixArray);
            } else {
                matrix = a5.Aa();
            }
            ImmutableMatrix a11 = matrix;
            DenseVector a12 = new DenseVector(a11.nRows());
            Vector a13 = a12;
            if (a11.nRows() < a11.nCols()) {
                a8 = new LinearEqualityConstraints(a11, a12);
                a7 = ((LinearConstraints)a8).dimensionOfRange() > 0 ? SimpleQPSolver.solve(a10, (LinearEqualityConstraints)a8, this.E.epsilon) : SimpleQPSolver.solve(a10, this.E.epsilon);
                a13 = a7.minimizer();
            }
            if (a13.norm(Integer.MAX_VALUE) < this.E.epsilon) {
                if (a5.size() == 0) {
                    return this.b(a4);
                }
                a8 = new LinearSystemSolver(a11.t(), this.E.epsilon);
                a7 = ((LinearSystemSolver)a8).solve(a9);
                int n = a6 = this.E.Aeq != null ? a7.size() - this.E.Aeq.nRows() : a7.size();
                if (this.m((Vector)a7, a6)) return this.b(a4);
                int a14 = this.b((Vector)a7, a6);
                a5.removeByIndex(a14);
            } else {
                int a15;
                double a16 = 1.0;
                a6 = 0;
                HashMap<Integer, Double> a17 = new HashMap<Integer, Double>();
                int n = a15 = 1;
                while (n <= this.E.A.nRows()) {
                    if (!a5.contains(a15)) {
                        Vector vector;
                        Vector a18 = this.E.A.getRow(a15);
                        if (!(vector.innerProduct(a13) >= 0.0)) {
                            double a19 = a18.innerProduct(a4) - this.E.b.get(a15);
                            a17.put(a15, a19 /= -a18.innerProduct(a13));
                            if (a19 < a16) {
                                a16 = a19;
                                a6 = a15;
                            }
                        }
                    }
                    n = ++a15;
                }
                if (a16 == 0.0) return this.b(a4);
                a4 = a4.add(a13.scaled(a16));
                if (a6 > 0) {
                    a5.add(a6);
                }
            }
            ++this.E.E;
            qPPrimalActiveSetSolver = this;
        }
        return this.b(a4);
    }

    private boolean m(Vector a2, int a3) {
        int a4;
        int n = a4 = 1;
        while (n <= a3) {
            if (a2.get(a4) < 0.0) {
                return false;
            }
            n = ++a4;
        }
        return true;
    }

    @Override
    public IterativeState getStates() {
        return this.E.deepCopy();
    }

    public QPSolution search() throws QPInfeasible {
        Vector a2 = this.E.problem.getGreaterThanConstraints().getFeasibleInitialPoint((LinearEqualityConstraints)this.E.problem.getEqualityConstraints());
        if (a2.get(a2.size()) > this.E.epsilon) {
            throw new QPInfeasible();
        }
        Vector[] vectorArray = new Vector[1];
        vectorArray[0] = CreateVector.subVector(a2, 1, a2.size() - 1);
        return this.search(vectorArray);
    }

    public void solve(StandardQPProblem1 problem, double epsilon, int maxIterations) {
        SuanShuUtils.assertArgument(IsMatrix.positiveDefinite(problem.f().Hessian()), "the Hessian must be positive definite", new Object[0]);
        this.E = new IterativeState(problem, epsilon, maxIterations, null);
    }

    public double minimum() {
        return this.E.problem.f().evaluate(this.E.x.toArray());
    }

    private QPSolution b(Vector a2) {
        QPPrimalActiveSetSolver a3;
        a3.E.x = new ImmutableVector(a2);
        final ImmutableVector a4 = new ImmutableVector(a2);
        return new QPSolution(){
            {
                1 a2;
            }

            @Override
            public ImmutableVector minimizer() {
                return a4;
            }

            @Override
            public boolean isUnique() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    public void solve(StandardQPProblem1 problem) {
        this.solve(problem, Math.sqrt(SuanShuUtils.autoEpsilon(problem.f().Hessian())), Integer.MAX_VALUE);
    }

    private int b(Vector a2, int a3) {
        int a4;
        int a5 = 0;
        double a6 = Double.POSITIVE_INFINITY;
        int n = a4 = 1;
        while (n <= a3) {
            if (a2.get(a4) < a6) {
                a6 = a2.get(a4);
                a5 = a4;
            }
            n = ++a4;
        }
        return a5;
    }

    public static class IterativeState
    implements IterativeAlgorithm.IterativeState {
        public final int maxIterations;
        public final StandardQPProblem1 problem;
        private int E = 0;
        public final double epsilon;
        public final ImmutableMatrix Aeq;
        public final ImmutableVector b;
        public ImmutableVector x;
        public final ImmutableMatrix A;

        @Override
        public int getIteration() {
            return this.E;
        }

        public /* synthetic */ IterativeState(StandardQPProblem1 a2, double a3, int a4, 1 a5) {
            a6(a2, a3, a4);
            IterativeState a6;
        }

        @Override
        public IterativeState deepCopy() {
            IterativeState a2 = new IterativeState(this.problem, this.epsilon, this.maxIterations);
            new IterativeState(this.problem, this.epsilon, this.maxIterations).x = this.x;
            a2.E = this.E;
            return a2;
        }

        private IterativeState(StandardQPProblem1 a2, double a3, int a4) {
            IterativeState a5;
            a5.problem = a2;
            a5.epsilon = a3;
            a5.maxIterations = a4;
            a5.A = a2.A();
            a5.b = a2.b();
            a5.Aeq = a2.getEqualityConstraints() != null ? a2.Aeq() : null;
            a5.x = null;
        }
    }
}

