/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.convex.quadraticprogramming.problem;

import com.numericalmethod.suanshu.analysis.function.rn2r1.QuadraticFunction;
import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.svd.SVD;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixMeasure;
import com.numericalmethod.suanshu.matrix.doubles.operation.PseudoInverse;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearEqualityConstraints;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class QPProblemEqualityConstraints
extends QuadraticFunction {
    private final LinearEqualityConstraints k;
    private final Matrix L;
    private final Matrix E;

    public QPProblemEqualityConstraints(QuadraticFunction f2, LinearEqualityConstraints equal) {
        this(QPProblemEqualityConstraints.b(f2, equal), equal);
    }

    private static ModifiedQPProblem b(QuadraticFunction a2, LinearEqualityConstraints a3) {
        ImmutableMatrix a4 = a3.A();
        SuanShuUtils.assertArgument(DimensionCheck.isFat(a4), "A in the equality constraints must be a fat matrix", new Object[0]);
        SuanShuUtils.assertArgument(MatrixMeasure.rank(a4) == a4.nRows(), "A must has full row rank", new Object[0]);
        PseudoInverse a5 = new PseudoInverse(a4);
        DenseMatrix a6 = new DenseMatrix(a4.nCols() - a4.nRows(), a4.nCols());
        Matrix[] matrixArray = new Matrix[2];
        matrixArray[0] = a4;
        matrixArray[1] = a6;
        DenseMatrix a7 = CreateMatrix.rbind(matrixArray);
        SVD a8 = new SVD(a7, true);
        DenseMatrix a9 = CreateMatrix.columns(a8.V(), a4.nRows() + 1, a4.nCols());
        Matrix a10 = a2.Hessian();
        Matrix a11 = a9.t().multiply(a10).multiply(a9);
        Vector a12 = a2.p();
        ImmutableVector a13 = a3.b();
        Matrix a14 = a10.multiply(a5);
        Vector a15 = a14.multiply(a13);
        Vector a16 = a15.add(a12);
        Vector a17 = a9.t().multiply(a16);
        QuadraticFunction a18 = new QuadraticFunction(a11, a17);
        return new ModifiedQPProblem(a18, a5, a9, null);
    }

    private QPProblemEqualityConstraints(ModifiedQPProblem a2, LinearEqualityConstraints a3) {
        super(a2.f);
        QPProblemEqualityConstraints a4;
        a4.k = a3;
        a4.E = a2.Aplus;
        a4.L = a2.Vr;
    }

    public ImmutableVector getSolutionToOriginalProblem(Vector phi) {
        Vector a2 = this.L.multiply(phi);
        Vector a3 = this.E.multiply(this.k.b());
        Vector a4 = a2.add(a3);
        return new ImmutableVector(a4);
    }

    public ImmutableMatrix Vr() {
        return new ImmutableMatrix(this.L);
    }

    public ImmutableMatrix Aplus() {
        return new ImmutableMatrix(this.E);
    }

    public static class 1 {
    }

    private static class ModifiedQPProblem {
        public final QuadraticFunction f;
        public final Matrix Vr;
        public final Matrix Aplus;

        private ModifiedQPProblem(QuadraticFunction a2, Matrix a3, Matrix a4) {
            ModifiedQPProblem a5;
            a5.f = a2;
            a5.Aplus = a3;
            a5.Vr = a4;
        }

        public /* synthetic */ ModifiedQPProblem(QuadraticFunction a2, Matrix a3, Matrix a4, 1 a5) {
            a6(a2, a3, a4);
            ModifiedQPProblem a6;
        }
    }
}

