/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.constraint.general;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.optimization.constrained.constraint.Constraints;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public abstract class GeneralConstraints
implements Constraints {
    private final ArrayList<RealScalarFunction> E = new ArrayList();

    @Override
    public int dimensionOfDomain() {
        return this.E.get(0).dimensionOfDomain();
    }

    @Override
    public ArrayList<RealScalarFunction> getConstraints() {
        ArrayList<RealScalarFunction> a2 = new ArrayList<RealScalarFunction>();
        a2.addAll(this.E);
        return a2;
    }

    public GeneralConstraints(Collection<RealScalarFunction> constraints) {
        Iterator<RealScalarFunction> a2;
        SuanShuUtils.assertArgument(!constraints.isEmpty(), "constraints cannot be empty", new Object[0]);
        RealScalarFunction a3 = constraints.iterator().next();
        SuanShuUtils.assertArgument(a3 != null, "found a <code>null</code> constrain", new Object[0]);
        int a4 = a3.dimensionOfDomain();
        Iterator<RealScalarFunction> iterator = a2 = constraints.iterator();
        while (iterator.hasNext()) {
            RealScalarFunction a5 = a2.next();
            SuanShuUtils.assertArgument(a5 != null, "found a <code>null</code> constrain", new Object[0]);
            SuanShuUtils.assertArgument(a4 == a5.dimensionOfDomain(), "all constrains must have the same domain dimension", new Object[0]);
            iterator = a2;
        }
        this.E.addAll(constraints);
    }

    @Override
    public Vector evaluate(double ... x) {
        int a2;
        int a3 = this.dimensionOfRange();
        DenseVector a4 = new DenseVector(a3);
        int n = a2 = 1;
        while (n <= a3) {
            a4.set(a2, this.E.get(a2 - 1).evaluate(x));
            n = ++a2;
        }
        return a4;
    }

    @Override
    public int dimensionOfRange() {
        return this.E.size();
    }

    public GeneralConstraints(RealScalarFunction ... constraints) {
        this(Arrays.asList(constraints));
    }
}

