/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.constraint;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.constrained.constraint.Constraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.EqualityConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.GreaterThanConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.LessThanConstraints;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class ConstraintsUtils {
    public static boolean isSatisfied(Constraints constraints, double ... x) {
        double a2 = SuanShuUtils.autoEpsilon(x);
        Vector a3 = constraints.evaluate(x);
        if (EqualityConstraints.class.isAssignableFrom(constraints.getClass())) {
            return DoubleUtils.compare(a3.norm(), 0.0, a2) == 0;
        }
        if (GreaterThanConstraints.class.isAssignableFrom(constraints.getClass())) {
            int a4;
            int n = a4 = 1;
            while (n <= a3.size()) {
                if (a3.get(a4) < -a2) {
                    return false;
                }
                n = ++a4;
            }
            return true;
        }
        if (LessThanConstraints.class.isAssignableFrom(constraints.getClass())) {
            int a5;
            int n = a5 = 1;
            while (n <= a3.size()) {
                if (a3.get(a5) > a2) {
                    return false;
                }
                n = ++a5;
            }
            return true;
        }
        throw new RuntimeException("unrecognized constraint type");
    }
}

