/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.number.complex;

import com.numericalmethod.suanshu.mathstructure.Field;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.NumberUtils;

public class Complex
extends Number
implements Field<Complex>,
NumberUtils.Comparable<Complex> {
    public static final Complex ONE;
    public static final Complex NEGATIVE_INFINITY;
    public final double real;
    public static final Complex ZERO;
    public final double imaginary;
    private static final long serialVersionUID = 1L;
    public static final Complex POSITIVE_INFINITY;
    public static final Complex NaN;
    public static final Complex I;

    public Complex conjugate() {
        return new Complex(this.real, -this.imaginary);
    }

    @Override
    public Complex opposite() {
        return new Complex(-this.real, -this.imaginary);
    }

    public double arg() {
        return Math.atan2(this.imaginary, this.real);
    }

    public Double toDouble() {
        if (!Complex.isReal(this)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = this.toString();
            throw new IllegalArgumentException(String.format("this complex number %s is not real", objectArray));
        }
        return new Double(this.real);
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Complex a2 = (Complex)obj;
        if (Complex.isNaN(a2)) {
            return Complex.isNaN(this);
        }
        if (DoubleUtils.compare(this.real, a2.real) != 0) {
            return false;
        }
        if (DoubleUtils.compare(this.imaginary, a2.imaginary) != 0) {
            return false;
        }
        return true;
    }

    public static boolean isInfinite(Complex z2) {
        return !Complex.isNaN(z2) && (Double.isInfinite(z2.real) || Double.isInfinite(z2.imaginary));
    }

    public Complex(double a2) {
        this(a2, 0.0);
    }

    public Complex(double a2, double b2) {
        if (Double.isNaN(a2) || Double.isNaN(b2)) {
            this.real = Double.NaN;
            this.imaginary = Double.NaN;
        } else {
            this.real = a2;
            this.imaginary = b2;
        }
    }

    public double modulus() {
        if (DoubleUtils.compare(this.imaginary, 0.0) == 0) {
            return Math.abs(this.real);
        }
        if (DoubleUtils.compare(this.real, 0.0) == 0) {
            return Math.abs(this.imaginary);
        }
        return Math.hypot(this.real, this.imaginary);
    }

    public String toString() {
        Object[] objectArray = new Object[3];
        objectArray[0] = this.real;
        objectArray[1] = this.imaginary >= 0.0 ? "+" : "";
        objectArray[2] = this.imaginary;
        return String.format("%f%s%fi", objectArray);
    }

    @Override
    public Complex ONE() {
        return ONE;
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 53 * a2 + (int)(Double.doubleToLongBits(this.real) ^ Double.doubleToLongBits(this.real) >>> 32);
        a2 = 53 * a2 + (int)(Double.doubleToLongBits(this.imaginary) ^ Double.doubleToLongBits(this.imaginary) >>> 32);
        return a2;
    }

    public static boolean isReal(Complex z2) {
        return DoubleUtils.compare(z2.imaginary, 0.0) == 0;
    }

    @Override
    public Complex multiply(Complex that) {
        double a2 = this.real * that.real;
        double a3 = this.imaginary * that.imaginary;
        return new Complex(a2 - a3, (this.real + this.imaginary) * (that.real + that.imaginary) - a2 - a3);
    }

    @Override
    public Complex add(Complex that) {
        return new Complex(this.real + that.real, this.imaginary + that.imaginary);
    }

    static {
        I = new Complex(0.0, 1.0);
        ZERO = new Complex(0.0, 0.0);
        ONE = new Complex(1.0, 0.0);
        POSITIVE_INFINITY = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        NEGATIVE_INFINITY = new Complex(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        NaN = new Complex(Double.NaN, Double.NaN);
    }

    public static boolean isNaN(Complex z2) {
        return Double.isNaN(z2.real) || Double.isNaN(z2.imaginary);
    }

    @Override
    public double doubleValue() {
        if (!Complex.isReal(this)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = this.toString();
            throw new IllegalArgumentException(String.format("this complex number %s is not real", objectArray));
        }
        return this.real;
    }

    @Override
    public Complex divide(Complex that) {
        Complex a2;
        if (Complex.isNaN(this) || Complex.isNaN(that)) {
            return NaN;
        }
        if (Complex.isInfinite(that) && !Complex.isInfinite(this)) {
            return that.ZERO();
        }
        double a3 = this.real;
        double a4 = this.imaginary;
        double a5 = that.real;
        double a6 = that.imaginary;
        if (Math.abs(a5) < Math.abs(a6)) {
            if (DoubleUtils.compare(a6, 0.0) == 0) {
                throw new ArithmeticException("division by zero");
            }
            double a7 = a5 / a6;
            double a8 = a5 * a7 + a6;
            a2 = new Complex((a3 * a7 + a4) / a8, (a4 * a7 - a3) / a8);
        } else {
            if (DoubleUtils.compare(a5, 0.0) == 0) {
                throw new ArithmeticException("division by zero");
            }
            double a9 = a6 / a5;
            double a10 = a6 * a9 + a5;
            a2 = new Complex((a4 * a9 + a3) / a10, (a4 - a3 * a9) / a10);
        }
        return a2;
    }

    @Override
    public int compare(Number that, double epsilon) {
        return DoubleUtils.compare(this.minus((Complex)that).modulus(), 0.0, epsilon);
    }

    @Override
    @Deprecated
    public long longValue() {
        throw new UnsupportedOperationException("Complex number cannot be converted to long.");
    }

    @Override
    public Complex inverse() throws Field.InverseNonExistent {
        if (DoubleUtils.compare(this.real, 0.0) == 0 && DoubleUtils.compare(this.imaginary, 0.0) == 0) {
            throw new Field.InverseNonExistent();
        }
        double a2 = this.modulus();
        return new Complex(this.real / a2, -this.imaginary / a2);
    }

    public static Complex fromPolar(double r2, double theta) {
        return new Complex(r2 * Math.cos(theta), r2 * Math.sin(theta));
    }

    @Override
    @Deprecated
    public int intValue() {
        throw new UnsupportedOperationException("Complex number cannot be converted to int.");
    }

    @Override
    public Complex minus(Complex that) {
        return new Complex(this.real - that.real, this.imaginary - that.imaginary);
    }

    @Override
    public Complex ZERO() {
        return ZERO;
    }
}

