/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.number.big;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import java.math.BigDecimal;
import java.math.MathContext;

public class BigDecimalUtils {
    public static final BigDecimal PI = new BigDecimal("3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679");

    public static BigDecimal getWhole(BigDecimal num) {
        return num.setScale(0, 1);
    }

    public static BigDecimal pow(BigDecimal a2, int b2) {
        return BigDecimalUtils.pow(a2, b2, Constant.MACH_SCALE);
    }

    public static BigDecimal pow(BigDecimal a2, BigDecimal b2) {
        return BigDecimalUtils.pow(a2, b2, Constant.MACH_SCALE);
    }

    public static boolean equals(BigDecimal n1, BigDecimal n2, int precision) {
        return BigDecimalUtils.compare(n1, n2, precision) == 0;
    }

    public static BigDecimal exp(BigDecimal x, int scale) {
        int a2 = BigDecimalUtils.getWhole(x).intValue();
        BigDecimal a3 = BigDecimalUtils.getFractional(x);
        BigDecimal a4 = BigDecimalUtils.pow(BigDecimalUtils.b(BigDecimal.ONE, scale), a2, scale);
        BigDecimal a5 = BigDecimalUtils.b(a3, scale);
        BigDecimal a6 = a4.multiply(a5);
        return a6.setScale(scale, 6);
    }

    private BigDecimalUtils() {
        BigDecimalUtils a2;
    }

    public static BigDecimal log(BigDecimal x) {
        return BigDecimalUtils.log(x, Constant.MACH_SCALE);
    }

    private static BigDecimal m(BigDecimal a2, int a3) {
        BigDecimal a4;
        SuanShuUtils.assertArgument(a2.signum() > 0, "x must be > 0", new Object[0]);
        int a5 = 2 * a3;
        BigDecimal a6 = a2;
        if (a6.compareTo(BigDecimal.valueOf(10L)) == 0) {
            a6 = BigDecimal.valueOf(2.302585092994);
        } else if (a6.compareTo(BigDecimal.valueOf(1L)) == 0) {
            a6 = BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = a4 = BigDecimal.ONE;
        while (!BigDecimalUtils.equals(bigDecimal, BigDecimal.ZERO, a3)) {
            BigDecimal a7 = BigDecimalUtils.exp(a6, a5);
            a4 = BigDecimal.ONE.subtract(a2.divide(a7, a5, 6));
            a6 = a6.subtract(a4);
            bigDecimal = a4;
        }
        return a6.setScale(a3, 6);
    }

    public static BigDecimal sum(double ... big) {
        int a2;
        BigDecimal a3 = BigDecimal.ZERO;
        double[] a4 = big;
        int a5 = big.length;
        int n = a2 = 0;
        while (n < a5) {
            double a6 = a4[a2];
            a3 = a3.add(BigDecimal.valueOf(a6));
            n = ++a2;
        }
        return a3;
    }

    private static BigDecimal b(BigDecimal a2, int a3) {
        MathContext a4 = new MathContext(a3);
        BigDecimal a5 = BigDecimal.ZERO;
        BigDecimal a6 = BigDecimal.ONE;
        BigDecimal a7 = new BigDecimal(1, a4);
        int a8 = 1;
        BigDecimal bigDecimal = a5;
        while (!BigDecimalUtils.equals(bigDecimal, a6, a3)) {
            a5 = a6;
            a7 = a7.multiply(a2, a4);
            a7 = a7.divide(BigDecimal.valueOf(a8), a3 + 1, 6);
            a6 = a5.add(a7);
            ++a8;
            bigDecimal = a5;
        }
        return a5.setScale(a3, 6);
    }

    public static BigDecimal getFractional(BigDecimal num) {
        return num.subtract(BigDecimalUtils.getWhole(num));
    }

    public static BigDecimal log(BigDecimal x, int scale) {
        BigDecimal a2;
        if (x.compareTo(BigDecimal.TEN) < 0) {
            a2 = BigDecimalUtils.m(x, scale);
        } else {
            int a3 = x.precision() - x.scale() - 1;
            BigDecimal a4 = BigDecimal.valueOf(10L).pow(a3);
            BigDecimal a5 = x.divide(a4);
            BigDecimal a6 = BigDecimalUtils.m(BigDecimal.valueOf(10L), scale);
            BigDecimal a7 = BigDecimalUtils.m(a5, scale);
            a2 = BigDecimal.valueOf(a3).multiply(a6).add(a7);
        }
        return a2.setScale(scale, 6);
    }

    public static BigDecimal exp(double x) {
        return BigDecimalUtils.exp(x, Constant.MACH_SCALE);
    }

    public static BigDecimal sum(BigDecimal ... big) {
        int a2;
        BigDecimal a3 = BigDecimal.ZERO;
        BigDecimal[] a4 = big;
        int a5 = big.length;
        int n = a2 = 0;
        while (n < a5) {
            BigDecimal a6 = a4[a2];
            a3 = a3.add(a6);
            n = ++a2;
        }
        return a3;
    }

    public static BigDecimal exp(BigDecimal x) {
        return BigDecimalUtils.exp(x, Constant.MACH_SCALE);
    }

    public static int compare(BigDecimal n1, BigDecimal n2, int precision) {
        BigDecimal a2 = BigDecimal.ONE.movePointLeft(precision);
        int a3 = n1.subtract(n2).abs().compareTo(a2);
        return a3 <= 0 ? 0 : n1.compareTo(n2);
    }

    public static BigDecimal exp(double x, int scale) {
        return BigDecimalUtils.exp(BigDecimal.valueOf(x), scale);
    }

    public static BigDecimal pow(BigDecimal a2, int b2, int scale) {
        if (b2 < 0) {
            return BigDecimal.ONE.divide(BigDecimalUtils.pow(a2, -b2, scale), scale, 6);
        }
        return a2.pow(b2).setScale(scale, 6);
    }

    public static BigDecimal pow(BigDecimal a2, BigDecimal b2, int scale) {
        BigDecimal a3 = b2;
        a3 = a3.multiply(BigDecimalUtils.log(a2, scale));
        a3 = BigDecimalUtils.exp(a3, scale);
        return a3;
    }
}

