/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.number;

import com.numericalmethod.suanshu.number.big.BigDecimalUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ScientificNotation
extends Number {
    public final BigDecimal significand;
    private final BigDecimal E = BigDecimal.valueOf(10L);
    private static final long serialVersionUID = 1L;
    public final int exponent;

    public ScientificNotation(double x) {
        this(new BigDecimal(x));
    }

    public BigDecimal value() {
        BigDecimal a2 = BigDecimalUtils.pow(this.E, this.exponent, Math.abs(this.exponent));
        BigDecimal a3 = this.significand.multiply(a2);
        a3.stripTrailingZeros();
        return a3;
    }

    public ScientificNotation(double significand, int exponent) {
        this.significand = new BigDecimal(significand);
        this.exponent = exponent;
    }

    public ScientificNotation(BigDecimal x) {
        BigDecimal a2;
        if (x.equals(BigDecimal.ZERO)) {
            this.significand = BigDecimal.ZERO;
            this.exponent = 0;
            return;
        }
        int a3 = 0;
        BigDecimal bigDecimal = a2 = x.abs();
        while (bigDecimal.compareTo(this.E) >= 0) {
            ++a3;
            bigDecimal = a2.divide(this.E);
        }
        BigDecimal bigDecimal2 = a2;
        while (bigDecimal2.compareTo(BigDecimal.ONE) < 0) {
            --a3;
            bigDecimal2 = a2.multiply(this.E);
        }
        this.significand = x.signum() > 0 ? a2 : a2.negate();
        this.exponent = a3;
    }

    @Override
    public long longValue() {
        return this.value().longValue();
    }

    public ScientificNotation(long x) {
        this(BigInteger.valueOf(x));
    }

    @Override
    public int intValue() {
        return this.value().intValue();
    }

    @Override
    public float floatValue() {
        return this.value().floatValue();
    }

    public ScientificNotation(BigInteger x) {
        this(new BigDecimal(x));
    }

    @Override
    public double doubleValue() {
        return this.value().doubleValue();
    }

    public ScientificNotation(BigDecimal significand, int exponent) {
        this.significand = significand;
        this.exponent = exponent;
    }
}

