/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.number;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.mathstructure.Field;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Real
extends Number
implements Field<Real>,
Comparable<Real> {
    private static final long serialVersionUID = 1L;
    public static final Real ZERO = new Real(BigDecimal.ZERO);
    private final BigDecimal E;
    public static final Real ONE = new Real(BigDecimal.ONE);

    @Override
    public Real minus(Real that) {
        return this.add((Real)that.opposite());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Real a2 = (Real)obj;
        if (this.E != a2.E && (this.E == null || this.E.compareTo(a2.E) != 0)) {
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Real that) {
        return this.E.compareTo(that.E);
    }

    @Override
    public Real multiply(Real that) {
        return new Real(this.E.multiply(that.E));
    }

    public Real(BigDecimal value) {
        this.E = value;
    }

    public Real(String value) {
        this.E = new BigDecimal(value);
    }

    @Override
    public Real divide(Real that) {
        return this.divide(that, Constant.MACH_SCALE);
    }

    public Real divide(Real that, int scale) {
        return new Real(this.E.divide(that.E, scale, 6));
    }

    @Override
    public Real add(Real that) {
        return new Real(this.E.add(that.E));
    }

    public String toString() {
        return this.E.stripTrailingZeros().toString();
    }

    public Real(long value) {
        this.E = BigDecimal.valueOf(value);
    }

    public Real(double value) {
        this.E = BigDecimal.valueOf(value);
    }

    @Override
    public float floatValue() {
        return this.E.floatValue();
    }

    @Override
    public Real ONE() {
        return ONE;
    }

    @Override
    public long longValue() {
        return this.E.longValue();
    }

    @Override
    public Real opposite() {
        return new Real(this.E.negate());
    }

    @Override
    public int intValue() {
        return this.E.intValue();
    }

    @Override
    public Real ZERO() {
        return ZERO;
    }

    public BigDecimal bigDecimal() {
        return this.E;
    }

    @Override
    public Real inverse() throws Field.InverseNonExistent {
        return ((Real)this.ONE()).divide(this);
    }

    @Override
    public double doubleValue() {
        return this.E.doubleValue();
    }

    public Real(BigInteger value) {
        this.E = new BigDecimal(value);
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 29 * a2 + (this.E != null ? this.E.hashCode() : 0);
        return a2;
    }
}

