/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.misc;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.matrix.doubles.MatrixTable;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.number.DoubleArrayMath;

public class SuanShuUtils {
    public static double autoEpsilon(double ... inputs) {
        double a2 = Math.abs(DoubleArrayMath.max(inputs)) * Math.sqrt(inputs.length) * Constant.EPSILON * 10.0;
        if (a2 == 0.0) {
            a2 = Double.MIN_NORMAL;
        }
        return a2;
    }

    public static double autoEpsilon(MatrixTable A) {
        return SuanShuUtils.autoEpsilon(MatrixUtils.to1DArray(A));
    }

    private SuanShuUtils() {
        SuanShuUtils a2;
    }

    public static void assertArgument(boolean condition, String errorMessage, Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(errorMessage, args));
        }
    }

    public static double autoEpsilon(double[] ... inputs) {
        int a2;
        double a3 = 0.0;
        double[][] a4 = inputs;
        int a5 = inputs.length;
        int n = a2 = 0;
        while (n < a5) {
            double a6 = SuanShuUtils.autoEpsilon(a4[a2]);
            if (a6 > a3) {
                a3 = a6;
            }
            n = ++a2;
        }
        return a3;
    }

    public static void assertOrThrow(RuntimeException error) {
        if (error != null) {
            throw error;
        }
    }
}

