/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.generic.matrixtype;

import com.numericalmethod.suanshu.mathstructure.Field;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.generic.Matrix;
import com.numericalmethod.suanshu.matrix.generic.matrixtype.GenericMatrix;
import com.numericalmethod.suanshu.number.Real;

public class RealMatrix
implements Matrix<RealMatrix, Real> {
    private final GenericMatrix<Real> E;

    public RealMatrix(int nRows, int nCols) {
        this.E = new GenericMatrix<Real>(nRows, nCols, Real.ZERO);
    }

    @Override
    public int nRows() {
        return this.E.nRows();
    }

    @Override
    public int nCols() {
        return this.E.nCols();
    }

    @Override
    public RealMatrix ZERO() {
        return new RealMatrix(new GenericMatrix<Real>(this.nRows(), this.nCols(), Real.ZERO));
    }

    public RealMatrix(Real[][] data) {
        this.E = new GenericMatrix((Field[][])data);
    }

    @Override
    public Real get(int row, int col) {
        return this.E.get(row, col);
    }

    @Override
    public RealMatrix ONE() {
        return new RealMatrix((GenericMatrix<Real>)new GenericMatrix<Real>(this.nRows(), this.nCols(), Real.ZERO).ONE());
    }

    private RealMatrix(GenericMatrix<Real> a2) {
        RealMatrix a3;
        a3.E = a2;
    }

    public RealMatrix(double[][] data) {
        this(RealMatrix.b(data));
    }

    @Override
    public RealMatrix scaled(Real scalar) {
        return new RealMatrix((GenericMatrix<Real>)this.E.scaled((Field)scalar));
    }

    public DenseMatrix doubleValue() {
        int a2;
        DenseMatrix a3 = new DenseMatrix(this.nRows(), this.nCols());
        int n = a2 = 1;
        while (n <= this.nRows()) {
            int a4;
            int n2 = a4 = 1;
            while (n2 <= this.nCols()) {
                a3.set(a2, a4, this.E.get(a2, a4).doubleValue());
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public RealMatrix minus(RealMatrix that) {
        return new RealMatrix(this.E.minus(that.E));
    }

    @Override
    public RealMatrix multiply(RealMatrix that) {
        return new RealMatrix(this.E.multiply(that.E));
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 37 * a2 + (this.E != null ? this.E.hashCode() : 0);
        return a2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RealMatrix a2 = (RealMatrix)obj;
        if (!(this.E == a2.E || this.E != null && this.E.equals(a2.E))) {
            return false;
        }
        return true;
    }

    public String toString() {
        return this.E.toString();
    }

    private static Real[][] b(double[][] a2) {
        int a3;
        int a4 = a2.length;
        int a5 = a2[0].length;
        Real[][] a6 = new Real[a4][a5];
        int n = a3 = 0;
        while (n < a4) {
            int a7;
            if (a2[a3].length != a5) {
                throw new IllegalArgumentException("data is a jagged array");
            }
            int n2 = a7 = 0;
            while (n2 < a5) {
                a6[a3][a7] = new Real(a2[a3][a7]);
                n2 = ++a7;
            }
            n = ++a3;
        }
        return a6;
    }

    @Override
    public RealMatrix opposite() {
        return new RealMatrix((GenericMatrix<Real>)this.E.opposite());
    }

    @Override
    public RealMatrix add(RealMatrix that) {
        return new RealMatrix(this.E.add(that.E));
    }

    @Override
    public void set(int row, int col, Real value) {
        this.E.set(row, col, value);
    }
}

