/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.generic.matrixtype;

import com.numericalmethod.suanshu.mathstructure.Field;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.generic.Matrix;
import com.numericalmethod.suanshu.matrix.generic.matrixtype.GenericMatrix;
import com.numericalmethod.suanshu.number.complex.Complex;

public class ComplexMatrix
implements Matrix<ComplexMatrix, Complex> {
    private final GenericMatrix<Complex> E;

    @Override
    public ComplexMatrix ZERO() {
        return new ComplexMatrix(new GenericMatrix<Complex>(this.nRows(), this.nCols(), Complex.ZERO));
    }

    @Override
    public int nRows() {
        return this.E.nRows();
    }

    @Override
    public Complex get(int row, int col) {
        return this.E.get(row, col);
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 61 * a2 + (this.E != null ? this.E.hashCode() : 0);
        return a2;
    }

    @Override
    public ComplexMatrix add(ComplexMatrix that) {
        return new ComplexMatrix(this.E.add(that.E));
    }

    public ComplexMatrix(Complex[][] data) {
        this.E = new GenericMatrix((Field[][])data);
    }

    public DenseMatrix doubleValue() {
        int a2;
        DenseMatrix a3 = new DenseMatrix(this.nRows(), this.nCols());
        int n = a2 = 1;
        while (n <= this.nRows()) {
            int a4;
            int n2 = a4 = 1;
            while (n2 <= this.nCols()) {
                a3.set(a2, a4, this.E.get(a2, a4).doubleValue());
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public ComplexMatrix opposite() {
        return new ComplexMatrix((GenericMatrix<Complex>)this.E.opposite());
    }

    @Override
    public int nCols() {
        return this.E.nCols();
    }

    @Override
    public ComplexMatrix minus(ComplexMatrix that) {
        return new ComplexMatrix(this.E.minus(that.E));
    }

    @Override
    public ComplexMatrix multiply(ComplexMatrix that) {
        return new ComplexMatrix(this.E.multiply(that.E));
    }

    @Override
    public ComplexMatrix scaled(Complex scalar) {
        return new ComplexMatrix((GenericMatrix<Complex>)this.E.scaled((Field)scalar));
    }

    public ComplexMatrix(int nRows, int nCols) {
        this.E = new GenericMatrix<Complex>(nRows, nCols, Complex.ZERO);
    }

    @Override
    public void set(int row, int col, Complex value) {
        this.E.set(row, col, value);
    }

    public ComplexMatrix(double[][] data) {
        this(ComplexMatrix.b(data));
    }

    private static Complex[][] b(double[][] a2) {
        int a3;
        int a4 = a2.length;
        int a5 = a2[0].length;
        Complex[][] a6 = new Complex[a4][a5];
        int n = a3 = 0;
        while (n < a4) {
            int a7;
            if (a2[a3].length != a5) {
                throw new IllegalArgumentException("data is a jagged array");
            }
            int n2 = a7 = 0;
            while (n2 < a5) {
                a6[a3][a7] = new Complex(a2[a3][a7]);
                n2 = ++a7;
            }
            n = ++a3;
        }
        return a6;
    }

    @Override
    public ComplexMatrix ONE() {
        return new ComplexMatrix((GenericMatrix<Complex>)new GenericMatrix<Complex>(this.nRows(), this.nCols(), Complex.ZERO).ONE());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComplexMatrix a2 = (ComplexMatrix)obj;
        if (!(this.E == a2.E || this.E != null && this.E.equals(a2.E))) {
            return false;
        }
        return true;
    }

    public String toString() {
        return this.E.toString();
    }

    private ComplexMatrix(GenericMatrix<Complex> a2) {
        ComplexMatrix a3;
        a3.E = a2;
    }
}

