/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.operation.positivedefinite;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.triangle.LDL;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;

public class MatthewsDavies
extends DenseMatrix {
    private final UpperTriangularMatrix F;
    private final DiagonalMatrix k;
    private final LowerTriangularMatrix L;
    private final DiagonalMatrix E;

    public MatthewsDavies(Matrix H) {
        super(H.nCols(), H.nRows());
        int a2;
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(H), "H must be a square matrix", new Object[0]);
        double a3 = SuanShuUtils.autoEpsilon(H);
        LDL a4 = new LDL(H);
        this.L = a4.L();
        this.F = a4.Lt();
        this.E = a4.D();
        this.k = new DiagonalMatrix(this.E);
        double a5 = 1.0;
        int n = a2 = 1;
        while (n <= this.k.nRows()) {
            double d2;
            double a6 = this.k.get(a2, a2);
            if (d2 > a3 && a6 < a5) {
                a5 = a6;
            }
            n = ++a2;
        }
        int n2 = a2 = 1;
        while (n2 <= this.k.nRows()) {
            if (this.k.get(a2, a2) <= a3) {
                this.k.set(a2, a2, a5);
            }
            n2 = ++a2;
        }
        Matrix a22 = this.L.multiply(this.k).multiply(this.F);
        this.overwrite(a22);
    }

    public UpperTriangularMatrix Lt() {
        return this.L.t();
    }

    public DiagonalMatrix Dhat() {
        return new DiagonalMatrix(this.k);
    }

    public DiagonalMatrix D() {
        return new DiagonalMatrix(this.E);
    }

    public LowerTriangularMatrix L() {
        return new LowerTriangularMatrix(this.L);
    }
}

