/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.operation;

import com.numericalmethod.suanshu.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation.SimpleMatrixMathOperation;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;

public class SubMatrixRef
implements Matrix {
    public final Matrix ref;
    public final MatrixMathOperation matrixComputation = new SimpleMatrixMathOperation();
    public final int colTo;
    public final int colFrom;
    public final int rowTo;
    public final int rowFrom;

    @Override
    public Matrix opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public Matrix ONE() {
        return new DenseMatrix(this.nRows(), this.nCols()).ONE();
    }

    public SubMatrixRef(Matrix A, int rowFrom, int rowTo, int colFrom, int colTo) {
        if (rowFrom < 1) {
            throw new IndexOutOfBoundsException("rowFrom is not valid; must count from 1");
        }
        if (rowTo > A.nRows()) {
            throw new IndexOutOfBoundsException("rowTo is not valid; cannot exceed A's nrows");
        }
        if (colFrom < 1) {
            throw new IndexOutOfBoundsException("colFrom is not valid; must count from 1");
        }
        if (colTo > A.nCols()) {
            throw new IndexOutOfBoundsException("colTo is not valid; cannot exceed A's ncols");
        }
        this.ref = A;
        this.rowFrom = rowFrom;
        this.rowTo = rowTo;
        this.colFrom = colFrom;
        this.colTo = colTo;
    }

    @Override
    public Vector getColumn(int col) {
        Vector a2 = CreateVector.subVector(this.ref.getColumn(col + this.colFrom - 1), this.rowFrom, this.rowTo);
        return a2;
    }

    @Override
    public Matrix multiply(Matrix that) {
        return this.matrixComputation.multiply((Matrix)this, that);
    }

    @Override
    public Matrix add(Matrix that) {
        return this.matrixComputation.add(this, that);
    }

    @Override
    public Matrix ZERO() {
        return new DenseMatrix(this.nRows(), this.nCols()).ZERO();
    }

    @Override
    public int nCols() {
        return this.colTo - this.colFrom + 1;
    }

    public SubMatrixRef(Matrix A) {
        this.ref = A;
        this.rowFrom = 1;
        this.rowTo = A.nRows();
        this.colFrom = 1;
        this.colTo = A.nCols();
    }

    @Override
    public Matrix minus(Matrix that) {
        return this.matrixComputation.minus(this, that);
    }

    @Override
    public Matrix t() {
        return new DenseMatrix(this).t();
    }

    @Override
    public int nRows() {
        return this.rowTo - this.rowFrom + 1;
    }

    @Override
    @Deprecated
    public void set(int row, int col, double value) throws MatrixAccessException {
        throw new MatrixAccessException("SubMatrixRef is immutable.");
    }

    @Override
    public Vector getRow(int row) {
        Vector a2 = CreateVector.subVector(this.ref.getRow(row + this.rowFrom - 1), this.colFrom, this.colTo);
        return a2;
    }

    @Override
    public Matrix scaled(double scalar) {
        return new DenseMatrix(this).scaled(scalar);
    }

    @Override
    public double get(int row, int col) {
        return this.ref.get(row + this.rowFrom - 1, col + this.colFrom - 1);
    }

    @Override
    public SubMatrixRef deepCopy() {
        return this;
    }

    public String toString() {
        return new DenseMatrix(this).toString();
    }

    @Override
    public Vector multiply(Vector v) {
        return this.matrixComputation.multiply((Matrix)this, v);
    }
}

