/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.operation;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation.SimpleMatrixMathOperation;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class ImmutableKroneckerProduct
implements Matrix {
    private final MatrixMathOperation k = new SimpleMatrixMathOperation();
    private final Matrix L;
    private final Matrix E;

    @Override
    public Matrix add(Matrix that) {
        return this.k.add(this, that);
    }

    @Override
    public Matrix scaled(double scalar) {
        return this.k.scaled(this, scalar);
    }

    @Override
    public int nCols() {
        return this.E.nCols() * this.L.nCols();
    }

    @Override
    public int nRows() {
        return this.E.nRows() * this.L.nRows();
    }

    @Override
    public Vector getColumn(int col) throws MatrixAccessException {
        int a2;
        DimensionCheck.throwIfInvalidColumn(this, col);
        double[] a3 = new double[this.nRows()];
        int n = a2 = 0;
        while (n < a3.length) {
            a3[a2] = this.get(a2 + 1, col);
            n = ++a2;
        }
        return new DenseVector(a3);
    }

    @Override
    public Matrix ZERO() {
        return new DenseMatrix(this.nRows(), this.nCols()).ZERO();
    }

    @Override
    public Matrix t() {
        return this.k.transpose(this);
    }

    @Override
    public void set(int row, int col, double value) throws MatrixAccessException {
        throw new MatrixAccessException("this matrix is immutable");
    }

    @Override
    public Matrix ONE() {
        return new DenseMatrix(this.nRows(), this.nCols()).ONE();
    }

    public ImmutableKroneckerProduct(Matrix a2, Matrix b2) {
        int a3;
        this.E = a2.deepCopy();
        this.L = b2.deepCopy();
        int a4 = a2.nRows();
        int a5 = a2.nCols();
        int a6 = b2.nRows();
        int a7 = b2.nCols();
        int a8 = a4 * a6;
        int a9 = a5 * a7;
        double[][] a10 = new double[a8][a9];
        int n = a3 = 0;
        while (n < a8) {
            int a11;
            int n2 = a11 = 0;
            while (n2 < a9) {
                a10[a3][a11] = a2.get(a3 / a6 + 1, a11 / a7 + 1) * b2.get(a3 % a6 + 1, a11 % a7 + 1);
                n2 = ++a11;
            }
            n = ++a3;
        }
    }

    @Override
    public Matrix opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public Matrix multiply(Matrix that) {
        return this.k.multiply((Matrix)this, that);
    }

    @Override
    public Vector getRow(int row) throws MatrixAccessException {
        int a2;
        DimensionCheck.throwIfInvalidRow(this, row);
        double[] a3 = new double[this.nCols()];
        int n = a2 = 0;
        while (n < a3.length) {
            a3[a2] = this.get(row, a2 + 1);
            n = ++a2;
        }
        return new DenseVector(a3);
    }

    @Override
    public Matrix deepCopy() {
        return this;
    }

    @Override
    public Vector multiply(Vector v) {
        return this.k.multiply((Matrix)this, v);
    }

    @Override
    public Matrix minus(Matrix that) {
        return this.k.minus(this, that);
    }

    @Override
    public double get(int row, int col) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        int a2 = row - 1;
        int a3 = col - 1;
        int a4 = this.L.nRows();
        int a5 = this.L.nCols();
        return this.E.get(a2 / a4 + 1, a3 / a5 + 1) * this.L.get(a2 % a4 + 1, a3 % a5 + 1);
    }
}

