/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.stationary;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class SORSweep {
    private final int F;
    private final Vector k;
    private final Matrix L;
    private final double E;

    public Vector forward(Vector x) {
        int a2;
        Vector a3 = new DenseVector(this.F).ZERO();
        int n = a2 = 1;
        while (n <= this.F) {
            int a4;
            double a5 = 0.0;
            int n2 = a4 = 1;
            while (n2 < a2) {
                a5 += this.L.get(a2, a4) * a3.get(a4);
                n2 = ++a4;
            }
            int n3 = a4 = a2 + 1;
            while (n3 <= this.F) {
                a5 += this.L.get(a2, a4) * x.get(a4);
                n3 = ++a4;
            }
            a5 = (this.k.get(a2) - a5) / this.L.get(a2, a2);
            a5 = x.get(a2) + this.E * (a5 - x.get(a2));
            a3.set(a2, a5);
            n = ++a2;
        }
        return a3;
    }

    public SORSweep(Matrix A, Vector b2, double omega) {
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(A), "A must be a square matrix", new Object[0]);
        SORSweep.b(A);
        this.L = A;
        this.k = b2;
        this.F = A.nCols();
        this.E = omega;
    }

    public Vector backward(Vector x) {
        int a2;
        Vector a3 = new DenseVector(this.F).ZERO();
        int n = a2 = this.F;
        while (true) {
            int a4;
            if (n < 1) break;
            double a5 = 0.0;
            int n2 = a4 = 1;
            while (n2 < a2) {
                a5 += this.L.get(a2, a4) * x.get(a4);
                n2 = ++a4;
            }
            int n3 = a4 = a2 + 1;
            while (n3 <= this.F) {
                a5 += this.L.get(a2, a4) * a3.get(a4);
                n3 = ++a4;
            }
            a5 = (this.k.get(a2) - a5) / this.L.get(a2, a2);
            a5 = x.get(a2) + this.E * (a5 - x.get(a2));
            a3.set(a2, a5);
            n = --a2;
        }
        return a3;
    }

    private static void b(Matrix a2) {
        int a3;
        int n = a3 = 1;
        while (n <= a2.nCols()) {
            if (Double.compare(a2.get(a3, a3), 0.0) == 0) {
                throw new IllegalArgumentException("diagonal entries must be non-zero");
            }
            n = ++a3;
        }
    }
}

