/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.stationary;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class JacobiSolver
implements IterativeSolver {
    @Override
    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }

    private Vector b(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, IterationMonitor a7) throws IterativeSolver.ConvergenceFailure {
        int a8;
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(a2), "the matrix A must be square", new Object[0]);
        JacobiSolver.b(a2);
        int a9 = a2.nCols();
        Vector a10 = a6;
        Vector a11 = a3.minus(a2.multiply(a10));
        boolean a12 = a5.isResidualSmall(a11.norm());
        int n = a8 = 0;
        int n2 = a4;
        while (n < n2 && !a12) {
            int a13;
            a7.addIterate(a10);
            Vector a14 = new DenseVector(a9).ZERO();
            int n3 = a13 = 1;
            while (n3 <= a9) {
                int a15;
                double a16 = 0.0;
                int n4 = a15 = 1;
                while (n4 <= a9) {
                    if (a15 != a13) {
                        a16 += a2.get(a13, a15) * a10.get(a15);
                    }
                    n4 = ++a15;
                }
                a16 = (a3.get(a13) - a16) / a2.get(a13, a13);
                a14.set(a13, a16);
                n3 = ++a13;
            }
            a10 = a14;
            a11 = a3.minus(a2.multiply(a10));
            a12 = a5.isResidualSmall(a11.norm());
            n = ++a8;
            n2 = a4;
        }
        a7.addIterate(a10);
        if (!a12) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS, a4 + " exceeded");
        }
        return a10;
    }

    private static void b(Matrix a2) {
        int a3;
        int n = a3 = 1;
        while (n <= a2.nCols()) {
            if (Double.compare(a2.get(a3, a3), 0.0) == 0) {
                throw new IllegalArgumentException("diagonal entries must be non-zero");
            }
            n = ++a3;
        }
    }

    @Override
    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.b(problem.A(), problem.b(), problem.getMaxIteration(), problem.getTolerance(), problem.getInitialGuess(), monitor);
    }
}

