/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.stationary.SORSweep;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class SSORPreconditioner
implements Preconditioner {
    private final Matrix L;
    private final double E;

    public SSORPreconditioner(Matrix A, double omega) {
        this.L = A.deepCopy();
        this.E = omega;
    }

    @Override
    public Vector transposeSolve(Vector x) {
        return this.solve(x);
    }

    @Override
    public Vector solve(Vector x) {
        SORSweep a2 = new SORSweep(this.L, x, this.E);
        Vector a3 = a2.forward(x.ZERO());
        return a2.backward(a3);
    }
}

