/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class SteepestDescentSolver
implements IterativeSolver {
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;
    private final int E;

    public SteepestDescentSolver() {
        this(50);
    }

    private Vector b(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, Preconditioner a7, IterationMonitor a8) throws IterativeSolver.ConvergenceFailure {
        int a9;
        Vector a10 = a6;
        Vector a11 = a3.minus(a2.multiply(a10));
        boolean a12 = a5.isResidualSmall(a11.norm());
        int n = a9 = 0;
        int n2 = a4;
        while (n < n2 && !a12) {
            SteepestDescentSolver a13;
            a8.addIterate(a10);
            Vector a14 = a7.solve(a11);
            Vector a15 = a2.multiply(a14);
            double a16 = a11.innerProduct(a14) / a15.innerProduct(a14);
            a10 = a10.add(a14.scaled(a16));
            a11 = (a9 + 1) % a13.E != 0 ? a11.minus(a15.scaled(a16)) : a3.minus(a2.multiply(a10));
            a12 = a5.isResidualSmall(a11.norm());
            n = ++a9;
            n2 = a4;
        }
        a8.addIterate(a10);
        if (!a12) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS, a4 + " exceeded");
        }
        return a10;
    }

    @Override
    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.b(problem.A(), problem.b(), problem.getMaxIteration(), problem.getTolerance(), problem.getInitialGuess(), problem.getLeftPreconditioner(), monitor);
    }

    @Override
    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }

    public SteepestDescentSolver(int residualRefreshRate) {
        this.E = residualRefreshRate;
    }
}

