/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.GivensMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class QuasiMinimalResidualSolver
implements IterativeSolver {
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;
    private final int E;

    private Vector b(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, IterationMonitor a7) throws IterativeSolver.ConvergenceFailure {
        int a8;
        Matrix a9 = a2.t();
        Vector a10 = a6;
        Vector a11 = a3.minus(a2.multiply(a10));
        Vector a12 = a11.deepCopy();
        double a13 = a11.norm();
        Vector a14 = a11.scaled(1.0 / a13);
        Vector a15 = a12.scaled(1.0 / a12.innerProduct(a14));
        double a16 = 0.0;
        double a17 = 0.0;
        Vector a18 = a14.ZERO();
        Vector a19 = a15.ZERO();
        GivensMatrix a20 = GivensMatrix.Ctor2x2(1.0, 0.0);
        GivensMatrix a21 = GivensMatrix.Ctor2x2(1.0, 0.0);
        Vector a22 = a15.ZERO();
        Vector a23 = a15.ZERO();
        double a24 = 0.0;
        double a25 = 1.0;
        boolean a26 = a5.isResidualSmall(a11.norm());
        int n = a8 = 0;
        int n2 = a4;
        while (n < n2 && !a26) {
            a7.addIterate(a10);
            Vector a27 = a2.multiply(a14);
            Vector a28 = a9.multiply(a15);
            double a29 = a27.innerProduct(a15);
            Vector a30 = a27.minus(a14.scaled(a29)).minus(a18.scaled(a16));
            double a31 = a29;
            Vector a32 = a28.minus(a15.scaled(a31)).minus(a19.scaled(a17));
            double a33 = a30.norm();
            Vector a34 = a30.scaled(1.0 / a33);
            double a35 = a34.innerProduct(a32);
            Vector a36 = a32.scaled(1.0 / a35);
            double a37 = a29;
            double a38 = a35;
            double a39 = a33;
            double[] dArray = new double[2];
            dArray[0] = 0.0;
            dArray[1] = a24;
            Vector a40 = new DenseVector(dArray);
            a40 = a21.multiply(a40);
            double[] dArray2 = new double[2];
            dArray2[0] = a40.get(2);
            dArray2[1] = a37;
            Vector a41 = new DenseVector(dArray2);
            a41 = a20.multiply(a41);
            GivensMatrix a42 = GivensMatrix.CtorToRotateRows(2, 1, 2, a41.get(2), a39);
            double[] dArray3 = new double[2];
            dArray3[0] = a25;
            dArray3[1] = 0.0;
            Vector a43 = new DenseVector(dArray3);
            a43 = a42.multiply(a43);
            double a44 = a43.get(2);
            double[] dArray4 = new double[2];
            dArray4[0] = a41.get(2);
            dArray4[1] = a39;
            Vector a45 = new DenseVector(dArray4);
            a45 = a42.multiply(a45);
            Vector a46 = a14.minus(a23.scaled(a41.get(1))).minus(a22.scaled(a40.get(1))).scaled(1.0 / a45.get(1));
            double a47 = a13 * a43.get(1);
            a10 = a10.add(a46.scaled(a47));
            a11 = a3.minus(a2.multiply(a10));
            a24 = a38;
            a22 = a23;
            a23 = a46;
            a18 = a14;
            a14 = a34;
            a19 = a15;
            a15 = a36;
            a16 = a35;
            a17 = a33;
            a21 = a20;
            a20 = a42;
            a25 = a44;
            a26 = a5.isResidualSmall(a11.norm());
            n = ++a8;
            n2 = a4;
        }
        a7.addIterate(a10);
        if (!a26) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS, a4 + " exceeded");
        }
        return a10;
    }

    @Override
    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }

    private Vector b(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, Preconditioner a7, Preconditioner a8, IterationMonitor a9) throws IterativeSolver.ConvergenceFailure {
        int a10;
        Matrix a11 = a2.t();
        Vector a12 = a6;
        Vector a13 = a3.minus(a2.multiply(a12));
        Vector a14 = a13.deepCopy();
        Vector a15 = a7.solve(a14);
        double a16 = a15.norm();
        Vector a17 = a13.deepCopy();
        Vector a18 = a8.transposeSolve(a17);
        double a19 = a18.norm();
        Vector a20 = a13.ZERO();
        Vector a21 = a13.ZERO();
        Vector a22 = a12.ZERO();
        Vector a23 = a13.ZERO();
        double a24 = 1.0;
        double a25 = -1.0;
        double a26 = 1.0;
        double a27 = 0.0;
        boolean a28 = a5.isResidualSmall(a13.norm());
        int n = a10 = 0;
        int n2 = a4;
        while (n < n2 && !a28) {
            QuasiMinimalResidualSolver a29;
            Vector a30;
            a9.addIterate(a12);
            if (Double.compare(a16, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, "rho = 0");
            }
            if (Double.compare(a19, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, "xi = 0");
            }
            Vector a31 = a14.scaled(1.0 / a16);
            a15 = a15.scaled(1.0 / a16);
            Vector a32 = a17.scaled(1.0 / a19);
            double a33 = (a18 = a18.scaled(1.0 / a19)).innerProduct(a15);
            if (Double.compare(a33, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, "delta = 0");
            }
            Vector a34 = a8.solve(a15);
            Vector a35 = a7.transposeSolve(a18);
            a20 = a34.minus(a20.scaled(a19 * a33 / a26));
            if (Double.compare(a26 = (a21 = a35.minus(a21.scaled(a16 * a33 / a26))).innerProduct(a30 = a2.multiply(a20)), 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, "epsilon = 0");
            }
            double a36 = a26 / a33;
            if (Double.compare(a36, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, "beta = 0");
            }
            a14 = a30.minus(a31.scaled(a36));
            a15 = a7.solve(a14);
            double a37 = a15.norm();
            a17 = a11.multiply(a21).minus(a32.scaled(a36));
            a18 = a8.transposeSolve(a17);
            a19 = a18.norm();
            double a38 = a37 / (a24 * Math.abs(a36));
            double a39 = 1.0 / Math.sqrt(1.0 + a38 * a38);
            if (Double.compare(a39, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, "gamma = 0");
            }
            a25 = -a25 * a16 * a39 * a39 / (a36 * a24 * a24);
            double a40 = a27 * a39;
            a40 *= a40;
            a22 = a20.scaled(a25).add(a22.scaled(a40));
            a23 = a30.scaled(a25).add(a23.scaled(a40));
            a12 = a12.add(a22);
            a13 = (a10 + 1) % a29.E != 0 ? a13.minus(a23) : a3.minus(a2.multiply(a12));
            a16 = a37;
            a27 = a38;
            a24 = a39;
            a28 = a5.isResidualSmall(a13.norm());
            n = ++a10;
            n2 = a4;
        }
        a9.addIterate(a12);
        if (!a28) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS, a4 + " exceeded");
        }
        return a12;
    }

    public QuasiMinimalResidualSolver(int residualRefreshRate) {
        this.E = residualRefreshRate;
    }

    public QuasiMinimalResidualSolver() {
        this(50);
    }

    @Override
    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.b(problem.A(), problem.b(), Math.min(problem.getMaxIteration(), problem.A().nCols()), problem.getTolerance(), problem.getInitialGuess(), problem.getLeftPreconditioner(), problem.getRightPreconditioner(), monitor);
    }
}

