/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.DeepCopyable;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.linearsystem.BackwardSubstitution;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.GivensMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.SubMatrixRef;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;
import java.util.Arrays;

public class GeneralizedMinimalResidualSolver
implements IterativeSolver {
    private final int E;

    public GeneralizedMinimalResidualSolver() {
        this.E = Integer.MAX_VALUE;
    }

    private Vector b(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, Preconditioner a7, IterationMonitor a8) throws IterativeSolver.ConvergenceFailure {
        int a9;
        GeneralizedMinimalResidualSolver a10;
        int a11 = Math.min(a10.E, a2.nCols());
        Vector[] a12 = new Vector[a11 + 1];
        DenseMatrix a13 = new DenseMatrix(a11 + 1, a11).ZERO();
        Vector a14 = a6;
        Vector a15 = a3.minus(a2.multiply(a14));
        a15 = a7.solve(a15);
        double a16 = a15.norm();
        GivensMatrix[] a17 = new GivensMatrix[a11];
        boolean a18 = a5.isResidualSmall(a16);
        int n = a9 = 0;
        int n2 = a4;
        while (n < n2 && !a18) {
            DeepCopyable a19;
            Vector a20;
            int a21;
            a12[0] = a15.scaled(1.0 / a16);
            Vector a22 = new DenseVector(a11 + 1, 0.0);
            a22.set(1, a16);
            int n3 = a21 = 1;
            int n4 = a11;
            while (n3 <= n4 && a9 < a4 && !a18) {
                int a23;
                int a24;
                a8.addIterate(a14);
                a20 = a2.multiply(a12[a21 - 1]);
                a20 = a7.solve(a20);
                a19 = new DenseVector(a11 + 1, 0.0);
                int n5 = a24 = 1;
                while (n5 <= a21) {
                    double a25 = a20.innerProduct(a12[a24 - 1]);
                    a19.set(a24, a25);
                    a20 = a20.minus(a12[a24 - 1].scaled(a25));
                    n5 = ++a24;
                }
                double a25 = a20.norm();
                a19.set(a21 + 1, a25);
                if (Double.compare(a25, 0.0) != 0) {
                    a12[a21] = a20.scaled(1.0 / a25);
                }
                int n6 = a23 = 1;
                while (true) {
                    if (n6 > a21 - 1) break;
                    a19 = a17[a23 - 1].multiply((Vector)a19);
                    n6 = ++a23;
                }
                a17[a21 - 1] = GivensMatrix.CtorToRotateRows(a11 + 1, a21, a21 + 1, a19.get(a21), a19.get(a21 + 1));
                a22 = a17[a21 - 1].multiply(a22);
                a19 = a17[a21 - 1].multiply((Vector)a19);
                int n7 = a23 = 1;
                while (n7 <= a21) {
                    a13.set(a23, a21, a19.get(a23));
                    n7 = ++a23;
                }
                a16 = Math.abs(a22.get(a21 + 1));
                ++a9;
                a18 = a5.isResidualSmall(a16);
                n3 = ++a21;
                n4 = a11;
            }
            a20 = CreateVector.subVector(a22, 1, --a21);
            a19 = new UpperTriangularMatrix(new SubMatrixRef(a13, 1, a21, 1, a21));
            Vector a26 = new BackwardSubstitution((UpperTriangularMatrix)a19).solve(a20);
            a14 = a14.add(CreateMatrix.cbind(Arrays.copyOf(a12, a21)).multiply(a26));
            a15 = a3.minus(a2.multiply(a14));
            a15 = a7.solve(a15);
            a16 = a15.norm();
            a18 = a5.isResidualSmall(a16);
            n = a9;
            n2 = a4;
        }
        a8.addIterate(a14);
        if (!a18) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS, a4 + " exceeded");
        }
        return a14;
    }

    @Override
    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.b(problem.A(), problem.b(), this.E >= problem.A().nCols() ? Math.min(problem.getMaxIteration(), problem.A().nCols()) : problem.getMaxIteration(), problem.getTolerance(), problem.getInitialGuess(), problem.getLeftPreconditioner(), monitor);
    }

    @Override
    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }

    public GeneralizedMinimalResidualSolver(int m2) {
        this.E = m2;
    }
}

