/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class ConjugateGradientSolver
implements IterativeSolver {
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;
    private final int E;

    public ConjugateGradientSolver() {
        this(50);
    }

    private Vector b(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, Preconditioner a7, IterationMonitor a8) throws IterativeSolver.ConvergenceFailure {
        int a9;
        Vector a10 = a6;
        Vector a11 = a3.minus(a2.multiply(a10));
        Vector a12 = a10.ZERO();
        double a13 = 1.0;
        boolean a14 = a5.isResidualSmall(a11.norm());
        int n = a9 = 0;
        int n2 = a4;
        while (n < n2 && !a14) {
            ConjugateGradientSolver a15;
            Vector a16;
            a8.addIterate(a10);
            Vector a17 = a7.solve(a11);
            double a18 = a11.innerProduct(a17);
            if (Double.compare(a18, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, "<r, z> = 0");
            }
            double a19 = a18 / a13;
            double a20 = (a12 = a17.add(a12.scaled(a19))).innerProduct(a16 = a2.multiply(a12));
            if (Double.compare(a20, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, "<p, q> = 0");
            }
            double a21 = a18 / a20;
            a10 = a10.add(a12.scaled(a21));
            a11 = (a9 + 1) % a15.E != 0 ? a11.minus(a16.scaled(a21)) : a3.minus(a2.multiply(a10));
            a13 = a18;
            a14 = a5.isResidualSmall(a11.norm());
            n = ++a9;
            n2 = a4;
        }
        a8.addIterate(a10);
        if (!a14) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS, a4 + " exceeded");
        }
        return a10;
    }

    @Override
    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.b(problem.A(), problem.b(), Math.min(problem.getMaxIteration(), problem.A().nCols()), problem.getTolerance(), problem.getInitialGuess(), problem.getLeftPreconditioner(), monitor);
    }

    @Override
    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }

    public ConjugateGradientSolver(int residualRefreshRate) {
        this.E = residualRefreshRate;
    }
}

