/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class ConjugateGradientNormalResidualSolver
implements IterativeSolver {
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;
    private final int E;

    @Override
    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.b(problem.A(), problem.b(), Math.min(problem.getMaxIteration(), problem.A().nCols()), problem.getTolerance(), problem.getInitialGuess(), problem.getLeftPreconditioner(), monitor);
    }

    public ConjugateGradientNormalResidualSolver() {
        this(50);
    }

    private Vector b(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, Preconditioner a7, IterationMonitor a8) throws IterativeSolver.ConvergenceFailure {
        int a9;
        Matrix a10 = a2.t();
        Vector a11 = a6;
        Vector a12 = a3.minus(a2.multiply(a11));
        Vector a13 = a11.ZERO();
        double a14 = 1.0;
        boolean a15 = a5.isResidualSmall(a12.norm());
        int n = a9 = 0;
        int n2 = a4;
        while (n < n2 && !a15) {
            ConjugateGradientNormalResidualSolver a16;
            a8.addIterate(a11);
            Vector a17 = a10.multiply(a12);
            Vector a18 = a7.solve(a17);
            double a19 = a18.innerProduct(a17);
            if (Double.compare(a19, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, "<z, rTilde> = 0");
            }
            double a20 = a19 / a14;
            Vector a21 = a2.multiply(a13 = a18.add(a13.scaled(a20)));
            double a22 = a21.innerProduct(a21);
            if (Double.compare(a22, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, "<w, w> = 0");
            }
            double a23 = a19 / a22;
            a11 = a11.add(a13.scaled(a23));
            a12 = (a9 + 1) % a16.E != 0 ? a12.minus(a21.scaled(a23)) : a3.minus(a2.multiply(a11));
            a14 = a19;
            a15 = a5.isResidualSmall(a12.norm());
            n = ++a9;
            n2 = a4;
        }
        a8.addIterate(a11);
        if (!a15) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS, a4 + " exceeded");
        }
        return a11;
    }

    @Override
    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }

    public ConjugateGradientNormalResidualSolver(int residualRefreshRate) {
        this.E = residualRefreshRate;
    }
}

