/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class BiconjugateGradientSolver
implements IterativeSolver {
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;
    private final int E;

    @Override
    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }

    private Vector b(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, Preconditioner a7, IterationMonitor a8) throws IterativeSolver.ConvergenceFailure {
        int a9;
        Matrix a10 = a2.t();
        Vector a11 = a6;
        Vector a12 = a3.minus(a2.multiply(a11));
        Vector a13 = a12.deepCopy();
        Vector a14 = a11.ZERO();
        Vector a15 = a11.ZERO();
        double a16 = 1.0;
        boolean a17 = a5.isResidualSmall(a12.norm());
        int n = a9 = 0;
        int n2 = a4;
        while (n < n2 && !a17) {
            BiconjugateGradientSolver a18;
            a8.addIterate(a11);
            Vector a19 = a7.solve(a12);
            Vector a20 = a7.transposeSolve(a13);
            double a21 = a13.innerProduct(a19);
            if (Double.compare(a21, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, "<z, rTilde> = 0");
            }
            double a22 = a21 / a16;
            a14 = a19.add(a14.scaled(a22));
            a15 = a20.add(a15.scaled(a22));
            Vector a23 = a2.multiply(a14);
            Vector a24 = a10.multiply(a15);
            double a25 = a23.innerProduct(a15);
            if (Double.compare(a25, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, "<Ap, pTilde> = 0");
            }
            double a26 = a21 / a25;
            a11 = a11.add(a14.scaled(a26));
            if ((a9 + 1) % a18.E != 0) {
                a12 = a12.minus(a23.scaled(a26));
                a13 = a13.minus(a24.scaled(a26));
            } else {
                a12 = a3.minus(a2.multiply(a11));
                a13 = a3.minus(a10.multiply(a11));
            }
            a16 = a21;
            a17 = a5.isResidualSmall(a12.norm());
            n = ++a9;
            n2 = a4;
        }
        a8.addIterate(a11);
        if (!a17) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS, a4 + " exceeded");
        }
        return a11;
    }

    public BiconjugateGradientSolver(int residualRefreshRate) {
        this.E = residualRefreshRate;
    }

    public BiconjugateGradientSolver() {
        this(50);
    }

    @Override
    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.b(problem.A(), problem.b(), Math.min(problem.getMaxIteration(), problem.A().nCols()), problem.getTolerance(), problem.getInitialGuess(), problem.getLeftPreconditioner(), monitor);
    }
}

