/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.SparseVector;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.AbsoluteTolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.IdentityPreconditioner;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public interface IterativeSolver {
    public Vector solve(Problem var1) throws ConvergenceFailure;

    public Vector solve(Problem var1, IterationMonitor var2) throws ConvergenceFailure;

    public static class ConvergenceFailure
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final Reason E;

        public ConvergenceFailure(Reason reason, String message) {
            super(message);
            this.E = reason;
        }

        public ConvergenceFailure(Reason reason) {
            this.E = reason;
        }

        public Reason getReason() {
            return this.E;
        }

        public static final class Reason
        extends Enum<Reason> {
            public static final /* enum */ Reason ITERATIONS;
            public static final /* enum */ Reason BREAKDOWN;
            private static final /* synthetic */ Reason[] E;

            private Reason() {
                Reason a2;
            }

            public static Reason valueOf(String name) {
                return Enum.valueOf(Reason.class, name);
            }

            public static Reason[] values() {
                return (Reason[])E.clone();
            }

            static {
                BREAKDOWN = new Reason();
                ITERATIONS = new Reason();
                Reason[] reasonArray = new Reason[2];
                reasonArray[0] = BREAKDOWN;
                reasonArray[1] = ITERATIONS;
                E = reasonArray;
            }
        }
    }

    public static class Problem {
        private Tolerance M;
        private final Matrix i;
        private int G;
        private final Vector F;
        private Preconditioner k;
        private Preconditioner L;
        private Vector E;

        public Problem withRightPreconditioner(Preconditioner preconditioner) {
            this.k = preconditioner;
            return this;
        }

        public Tolerance getTolerance() {
            return this.M;
        }

        public int getMaxIteration() {
            return this.G;
        }

        public Problem withInitialGuess(Vector initialGuess) {
            this.E = initialGuess;
            return this;
        }

        public Preconditioner getRightPreconditioner() {
            return this.k;
        }

        public Vector b() {
            return this.F.deepCopy();
        }

        public Preconditioner getLeftPreconditioner() {
            return this.L;
        }

        public Problem(Matrix A, Vector b2) {
            SuanShuUtils.assertArgument(A.nRows() == b2.size(), "A's nrows must equal to b's size", new Object[0]);
            this.i = A.deepCopy();
            this.F = b2.deepCopy();
            this.G = Integer.MAX_VALUE;
            this.M = new AbsoluteTolerance();
            this.E = new SparseVector(A.nCols());
            this.L = new IdentityPreconditioner();
            this.k = new IdentityPreconditioner();
        }

        public Problem withLeftPreconditioner(Preconditioner preconditioner) {
            this.L = preconditioner;
            return this;
        }

        public Problem withTolerance(Tolerance tolerance) {
            this.M = tolerance;
            return this;
        }

        public Matrix A() {
            return this.i.deepCopy();
        }

        public Problem withMaxIteration(int maxIteration) {
            this.G = maxIteration;
            return this;
        }

        public Vector getInitialGuess() {
            return this.E;
        }
    }
}

