/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse;

import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.SparseStructure;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.number.DoubleArrayMath;
import com.numericalmethod.suanshu.number.Real;
import com.numericalmethod.suanshu.vector.doubles.IsVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;

public class SparseVector
implements Vector,
Iterable<Entry>,
SparseStructure {
    private final int L;
    private final LinkedList<Entry> E;

    @Override
    public double get(int index) {
        if (index < 1 || index > this.L) {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.L;
            objectArray[1] = index;
            throw new IllegalArgumentException(String.format("out-of-range [1:%d] index: %d", objectArray));
        }
        for (Entry a2 : this.E) {
            if (a2.L == index) {
                return a2.E;
            }
            if (a2.L <= index) continue;
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public Vector pow(double scalar) {
        java.util.Iterator a2;
        double a3 = Math.pow(0.0, scalar);
        if (Double.compare(0.0, a3) != 0) {
            java.util.Iterator a4;
            double[] a5 = R.rep(a3, this.L);
            java.util.Iterator iterator = a4 = this.E.iterator();
            while (iterator.hasNext()) {
                Entry a6 = (Entry)a4.next();
                a5[((Entry)a6).L - 1] = Math.pow(a6.E, scalar);
                iterator = a4;
            }
            return new DenseVector(a5);
        }
        LinkedList<Entry> a7 = new LinkedList<Entry>();
        java.util.Iterator iterator = a2 = this.E.iterator();
        while (iterator.hasNext()) {
            Entry a8 = (Entry)a2.next();
            a7.add(new Entry(a8.L, Math.pow(a8.E, scalar)));
            iterator = a2;
        }
        return new SparseVector(this.L, a7);
    }

    @Override
    public Vector add(double scalar) {
        java.util.Iterator a2;
        double[] a3 = R.rep(scalar, this.L);
        java.util.Iterator iterator = a2 = this.E.iterator();
        while (iterator.hasNext()) {
            Entry a4 = (Entry)a2.next();
            int n = a4.L - 1;
            a3[n] = a3[n] + a4.E;
            iterator = a2;
        }
        return new DenseVector(a3);
    }

    @Override
    public int nnz() {
        return this.E.size();
    }

    @Override
    public double norm() {
        return this.norm(2);
    }

    @Override
    public Vector scaled(double scalar) {
        java.util.Iterator a2;
        if (Double.compare(0.0, scalar) == 0) {
            return new SparseVector(this.L);
        }
        LinkedList<Entry> a3 = new LinkedList<Entry>();
        java.util.Iterator iterator = a2 = this.E.iterator();
        while (iterator.hasNext()) {
            Entry a4 = (Entry)a2.next();
            a3.add(new Entry(a4.L, scalar * a4.E));
            iterator = a2;
        }
        return new SparseVector(this.L, a3);
    }

    @Override
    public Vector opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public Vector minus(Vector that) {
        java.util.Iterator a2;
        if (that instanceof SparseVector) {
            return this.b((SparseVector)that, -1);
        }
        IsVector.throwIfNotEqualSize(this, that);
        Vector a3 = that.opposite();
        java.util.Iterator iterator = a2 = this.E.iterator();
        while (iterator.hasNext()) {
            Entry a4 = (Entry)a2.next();
            a3.set(a4.L, a4.E + a3.get(a4.L));
            iterator = a2;
        }
        return a3;
    }

    @Override
    public Vector minus(double scalar) {
        return this.add(-scalar);
    }

    @Override
    public Vector divide(Vector that) {
        java.util.Iterator a2;
        IsVector.throwIfNotEqualSize(this, that);
        SparseVector a3 = new SparseVector(this);
        java.util.Iterator iterator = a2 = a3.E.iterator();
        while (iterator.hasNext()) {
            Entry a4 = (Entry)a2.next();
            a3.set(a4.L, a4.E / that.get(a4.L));
            iterator = a2;
        }
        return a3;
    }

    @Override
    public double innerProduct(Vector that) {
        java.util.Iterator a2;
        if (that instanceof SparseVector) {
            return this.innerProduct((SparseVector)that);
        }
        IsVector.throwIfNotEqualSize(this, that);
        double a3 = 0.0;
        java.util.Iterator iterator = a2 = this.E.iterator();
        while (iterator.hasNext()) {
            Entry a4 = (Entry)a2.next();
            a3 += a4.E * that.get(a4.L);
            iterator = a2;
        }
        return a3;
    }

    @Override
    public int dropTolerance(double tolerance) {
        int a2 = 0;
        java.util.Iterator a3 = this.E.iterator();
        while (a3.hasNext()) {
            if (Double.compare(Math.abs(((Entry)a3.next()).E), tolerance) > 0) continue;
            a3.remove();
            ++a2;
        }
        return a2;
    }

    public SparseVector(int size) {
        this.L = size;
        this.E = new LinkedList();
    }

    public SparseVector multiply(SparseVector a2) {
        SparseVector a3;
        IsVector.throwIfNotEqualSize(a3, a2);
        LinkedList<Entry> a4 = new LinkedList<Entry>();
        java.util.Iterator a5 = a3.E.iterator();
        java.util.Iterator a6 = a2.E.iterator();
        Entry a7 = a5.hasNext() ? (Entry)a5.next() : null;
        Entry a8 = a6.hasNext() ? (Entry)a6.next() : null;
        Entry entry = a7;
        while (entry != null && a8 != null) {
            if (a7.L < a8.L) {
                entry = a7 = a5.hasNext() ? (Entry)a5.next() : null;
                continue;
            }
            if (a7.L > a8.L) {
                a8 = a6.hasNext() ? (Entry)a6.next() : null;
                entry = a7;
                continue;
            }
            double a9 = a7.E * a8.E;
            if (Double.compare(0.0, a9) != 0) {
                a4.add(new Entry(a7.L, a9));
            }
            a7 = a5.hasNext() ? (Entry)a5.next() : null;
            a8 = a6.hasNext() ? (Entry)a6.next() : null;
            entry = a7;
        }
        return new SparseVector(a3.L, a4);
    }

    @Override
    public double norm(int p) {
        java.util.Iterator a2;
        if (p == Integer.MAX_VALUE) {
            return DoubleArrayMath.max(DoubleArrayMath.abs(this.toArray()));
        }
        if (p == Integer.MIN_VALUE) {
            return DoubleArrayMath.min(DoubleArrayMath.abs(this.toArray()));
        }
        double a3 = 0.0;
        java.util.Iterator iterator = a2 = this.E.iterator();
        while (iterator.hasNext()) {
            Entry a4 = (Entry)a2.next();
            a3 += Math.pow(a4.E, p);
            iterator = a2;
        }
        a3 = Math.pow(a3, 1.0 / (double)p);
        return a3;
    }

    public SparseVector(int size, int[] indices, double[] values) {
        int a2;
        int a3;
        if (indices.length != values.length) {
            throw new IllegalArgumentException("sizes of input arrays mismatch");
        }
        this.L = size;
        Entry[] a4 = new Entry[values.length];
        int n = a3 = 0;
        while (n < values.length) {
            if (indices[a3] < 1 || indices[a3] > size) {
                throw new IndexOutOfBoundsException("out-of-range index: " + indices[a3]);
            }
            a4[a3] = new Entry(indices[a3], values[a3]);
            n = ++a3;
        }
        Arrays.sort(a4, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return o1.L < o2.L ? -1 : 1;
            }
            {
                1 a2;
            }
        });
        this.E = new LinkedList();
        a3 = 0;
        int n2 = a2 = 0;
        while (n2 < a4.length) {
            if (a3 >= a4[a2].L) {
                throw new IllegalArgumentException("duplicated indices: " + a4[a2].L);
            }
            a3 = a4[a2].L;
            this.E.add(a4[a2]);
            n2 = ++a2;
        }
    }

    @Override
    public Vector multiply(Vector v) {
        java.util.Iterator a2;
        if (v instanceof SparseVector) {
            return this.multiply((SparseVector)v);
        }
        IsVector.throwIfNotEqualSize(this, v);
        SparseVector a3 = new SparseVector(this);
        java.util.Iterator iterator = a2 = a3.E.iterator();
        while (iterator.hasNext()) {
            Entry a4 = (Entry)a2.next();
            a3.set(a4.L, a4.E * v.get(a4.L));
            iterator = a2;
        }
        return a3;
    }

    @Override
    public SparseVector minus(SparseVector a2) {
        SparseVector a3;
        return a3.b(a2, -1);
    }

    @Override
    public int size() {
        return this.L;
    }

    @Override
    public SparseVector add(SparseVector a2) {
        SparseVector a3;
        return a3.b(a2, 1);
    }

    private SparseVector b(SparseVector a2, int a3) {
        SparseVector a4;
        IsVector.throwIfNotEqualSize(a4, a2);
        LinkedList<Entry> a5 = new LinkedList<Entry>();
        java.util.Iterator a6 = a4.E.iterator();
        java.util.Iterator a7 = a2.E.iterator();
        Entry a8 = a6.hasNext() ? (Entry)a6.next() : null;
        Entry a9 = a7.hasNext() ? (Entry)a7.next() : null;
        Entry entry = a8;
        while (entry != null || a9 != null) {
            if (a8 != null && (a9 == null || a8.L < a9.L)) {
                a5.add(new Entry(a8.L, a8.E));
                entry = a8 = a6.hasNext() ? (Entry)a6.next() : null;
                continue;
            }
            if (a9 != null && (a8 == null || a8.L > a9.L)) {
                a5.add(new Entry(a9.L, (double)a3 * a9.E));
                a9 = a7.hasNext() ? (Entry)a7.next() : null;
                entry = a8;
                continue;
            }
            double a10 = a8.E + (double)a3 * a9.E;
            if (Double.compare(0.0, a10) != 0) {
                a5.add(new Entry(a8.L, a10));
            }
            a8 = a6.hasNext() ? (Entry)a6.next() : null;
            a9 = a7.hasNext() ? (Entry)a7.next() : null;
            entry = a8;
        }
        return new SparseVector(a4.L, a5);
    }

    @Override
    public double[] toArray() {
        java.util.Iterator a2;
        double[] a3 = R.rep(0.0, this.L);
        java.util.Iterator iterator = a2 = this.E.iterator();
        while (iterator.hasNext()) {
            Entry a4 = (Entry)a2.next();
            a3[((Entry)a4).L - 1] = a4.E;
            iterator = a2;
        }
        return a3;
    }

    @Override
    public java.util.Iterator<Entry> iterator() {
        return new Iterator(this.E.listIterator());
    }

    @Override
    public double innerProduct(SparseVector a2) {
        SparseVector a3;
        IsVector.throwIfNotEqualSize(a3, a2);
        double a4 = 0.0;
        java.util.Iterator a5 = a3.E.iterator();
        java.util.Iterator a6 = a2.E.iterator();
        Entry a7 = a5.hasNext() ? (Entry)a5.next() : null;
        Entry a8 = a6.hasNext() ? (Entry)a6.next() : null;
        Entry entry = a7;
        while (entry != null && a8 != null) {
            if (a7.L < a8.L) {
                entry = a7 = a5.hasNext() ? (Entry)a5.next() : null;
                continue;
            }
            if (a7.L > a8.L) {
                a8 = a6.hasNext() ? (Entry)a6.next() : null;
                entry = a7;
                continue;
            }
            a4 += a7.E * a8.E;
            a7 = a5.hasNext() ? (Entry)a5.next() : null;
            a8 = a6.hasNext() ? (Entry)a6.next() : null;
            entry = a7;
        }
        return a4;
    }

    @Override
    public Vector add(Vector that) {
        java.util.Iterator a2;
        if (that instanceof SparseVector) {
            return this.b((SparseVector)that, 1);
        }
        IsVector.throwIfNotEqualSize(this, that);
        DenseVector a3 = new DenseVector(that);
        java.util.Iterator iterator = a2 = this.E.iterator();
        while (iterator.hasNext()) {
            Entry a4 = (Entry)a2.next();
            a3.set(a4.L, a4.E + a3.get(a4.L));
            iterator = a2;
        }
        return a3;
    }

    @Override
    public Vector ZERO() {
        return new SparseVector(this.L);
    }

    @Override
    public double angle(Vector that) {
        double a2 = this.innerProduct(that);
        a2 /= this.norm();
        a2 /= that.norm();
        a2 = Math.acos(a2);
        return a2;
    }

    @Override
    public void set(int index, double value) {
        if (index < 1 || index > this.L) {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.L;
            objectArray[1] = index;
            throw new IllegalArgumentException(String.format("out-of-range [1:%d] index: %d", objectArray));
        }
        ListIterator<Entry> a2 = this.E.listIterator();
        while (a2.hasNext()) {
            Entry a3 = (Entry)a2.next();
            if (a3.L == index) {
                if (Double.compare(0.0, value) != 0) {
                    a3.E = value;
                } else {
                    a2.remove();
                }
                return;
            }
            if (a3.L <= index) continue;
            if (Double.compare(0.0, value) != 0) {
                a2.previous();
                a2.add(new Entry(index, value));
            }
            return;
        }
        this.E.addLast(new Entry(index, value));
    }

    @Override
    public Vector scaled(Real scalar) {
        return this.scaled(scalar.doubleValue());
    }

    private SparseVector(int a2, LinkedList<Entry> a3) {
        SparseVector a4;
        a4.L = a2;
        a4.E = a3;
    }

    public String toString() {
        java.util.Iterator a2;
        StringBuilder a3 = new StringBuilder();
        java.util.Iterator iterator = a2 = this.E.iterator();
        while (iterator.hasNext()) {
            Entry a4 = (Entry)a2.next();
            a3.append(a4.toString()).append("\n");
            iterator = a2;
        }
        return a3.toString();
    }

    @Override
    public SparseVector deepCopy() {
        return new SparseVector(this);
    }

    public SparseVector(SparseVector that) {
        this(that.L);
        java.util.Iterator a2;
        java.util.Iterator iterator = a2 = that.E.iterator();
        while (iterator.hasNext()) {
            Entry a3 = (Entry)a2.next();
            this.E.add(new Entry(a3.L, a3.E));
            iterator = a2;
        }
    }

    public static class Iterator
    implements java.util.Iterator<Entry> {
        private final ListIterator<Entry> E;

        public Iterator(ListIterator<Entry> a2) {
            Iterator a3;
            a3.E = a2;
        }

        @Override
        public Entry next() {
            return this.E.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cannot remove an element in a vector; set it to zero instead");
        }

        @Override
        public boolean hasNext() {
            return this.E.hasNext();
        }
    }

    public static class Entry {
        private int L;
        private double E;

        public String toString() {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.L;
            objectArray[1] = this.E;
            return String.format("[%d] %.4f", objectArray);
        }

        public Entry(int a2, double a3) {
            Entry a4;
            a4.L = a2;
            a4.E = a3;
        }

        public int index() {
            return this.L;
        }

        public double value() {
            return this.E;
        }
    }
}

