/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.Densifiable;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.TriangularData;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.TriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class LowerTriangularMatrix
extends TriangularMatrix<LowerTriangularMatrix>
implements Densifiable {
    public LowerTriangularMatrix(LowerTriangularMatrix L) {
        this((MyDenseDataImpl)L.getMatrixData().deepCopy());
    }

    @Override
    public LowerTriangularMatrix scaled(double scalar) {
        return new LowerTriangularMatrix(new MyDenseDataImpl(this.getMatrixData().scaled(scalar)));
    }

    public LowerTriangularMatrix(Matrix A) {
        this(A.nRows());
        int a2;
        if (!DimensionCheck.isSquare(A)) {
            throw new IllegalArgumentException("a lower triangular matrix must be square");
        }
        int n = a2 = 1;
        while (n <= this.dim()) {
            int a3;
            int n2 = a3 = 1;
            while (n2 <= a2) {
                this.set(a2, a3, A.get(a2, a3));
                n2 = ++a3;
            }
            n = ++a2;
        }
    }

    @Override
    public DenseMatrix toDense() {
        int a2;
        double[] a3 = this.getDataArray();
        double[] a4 = new double[this.nRows() * this.nCols()];
        int a5 = 0;
        int a6 = 1;
        int n = a2 = 0;
        while (n < a4.length) {
            int a7;
            int n2 = a7 = 0;
            while (n2 < a6) {
                a4[a2 + a7] = a3[a5++];
                n2 = ++a7;
            }
            ++a6;
            n = a2 += this.nCols();
        }
        return new DenseMatrix(a4, this.nRows(), this.nCols());
    }

    @Override
    public LowerTriangularMatrix ZERO() {
        return new LowerTriangularMatrix(this.dim());
    }

    @Override
    public DenseVector getRow(int row) {
        int a2;
        if (row < 1) {
            throw new IllegalArgumentException("row/col counts from 1");
        }
        if (row > this.nRows()) {
            throw new IllegalArgumentException("invalid index");
        }
        double[] a3 = this.getDataArray();
        double[] a4 = new double[this.nCols()];
        int a5 = row * (row - 1) >> 1;
        int n = a2 = 0;
        while (n < row) {
            a4[a2] = a3[a2 + a5];
            n = ++a2;
        }
        return new DenseVector(a4);
    }

    @Override
    public LowerTriangularMatrix ONE() {
        int a2;
        LowerTriangularMatrix a3 = new LowerTriangularMatrix(this.dim());
        int n = a2 = 1;
        while (n <= this.dim()) {
            a3.set(a2, a2, 1.0);
            n = ++a2;
        }
        return a3;
    }

    @Override
    public LowerTriangularMatrix deepCopy() {
        return new LowerTriangularMatrix(this);
    }

    @Override
    public LowerTriangularMatrix add(LowerTriangularMatrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        return new LowerTriangularMatrix(new MyDenseDataImpl(this.getMatrixData().add(that.getMatrixData())));
    }

    public LowerTriangularMatrix(double[][] data) {
        this(data[data.length - 1].length);
        int a2;
        int n = a2 = 1;
        while (n <= this.dim()) {
            int a3;
            if (data[a2 - 1].length != a2) {
                throw new IllegalArgumentException("data set is not lower triangular");
            }
            int n2 = a3 = 1;
            while (n2 <= a2) {
                this.set(a2, a3, data[a2 - 1][a3 - 1]);
                n2 = ++a3;
            }
            n = ++a2;
        }
    }

    @Override
    public LowerTriangularMatrix minus(LowerTriangularMatrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        return new LowerTriangularMatrix(new MyDenseDataImpl(this.getMatrixData().minus(that.getMatrixData())));
    }

    public LowerTriangularMatrix(int dim) {
        this(new MyDenseDataImpl(dim));
    }

    @Override
    public DenseVector getColumn(int col) {
        if (col < 1) {
            throw new IllegalArgumentException("row/col counts from 1");
        }
        if (col > this.nCols()) {
            throw new IllegalArgumentException("invalid index");
        }
        double[] a2 = this.getDataArray();
        double[] a3 = new double[this.nRows()];
        int a4 = (col + 2) * (col - 1) >> 1;
        int a5 = col - 1;
        int a6 = col;
        int n = a5;
        while (n < a3.length) {
            a3[a5] = a2[a4];
            a4 += a6;
            ++a6;
            n = ++a5;
        }
        return new DenseVector(a3);
    }

    private LowerTriangularMatrix(MyDenseDataImpl a2) {
        super(a2);
        LowerTriangularMatrix a3;
    }

    @Override
    public LowerTriangularMatrix multiply(LowerTriangularMatrix that) {
        int a2;
        DimensionCheck.throwIfDifferentDimension(this, that);
        TriangularData a3 = this.getMatrixData();
        TriangularData a4 = that.getMatrixData();
        MyDenseDataImpl a5 = new MyDenseDataImpl(this.dim());
        int n = a2 = 1;
        while (n <= this.dim()) {
            int a6;
            int n2 = a6 = 1;
            while (n2 <= a2) {
                double a7 = 0.0;
                int n3 = a6;
                while (n3 <= a2) {
                    int a8;
                    a7 += a3.get(a2, a8) * a4.get(a8, a6);
                    n3 = ++a8;
                }
                a5.set(a2, a6, a7);
                n2 = ++a6;
            }
            n = ++a2;
        }
        return new LowerTriangularMatrix(a5);
    }

    @Override
    public UpperTriangularMatrix t() {
        int a2;
        UpperTriangularMatrix a3 = new UpperTriangularMatrix(this.dim());
        double[] a4 = a3.getDataArray();
        double[] a5 = this.getDataArray();
        int a6 = 0;
        int n = a2 = 1;
        while (n <= this.nCols()) {
            int a7 = (a2 + 2) * (a2 - 1) >> 1;
            int a8 = a2 - 1;
            int a9 = 0;
            int n2 = a8;
            while (n2 < this.nRows()) {
                a4[a6++] = a5[a7 + a9];
                a9 += ++a8;
                n2 = a8;
            }
            n = ++a2;
        }
        return a3;
    }

    private static class MyDenseDataImpl
    extends TriangularData {
        @Override
        public MyDenseDataImpl deepCopy() {
            return new MyDenseDataImpl(Arrays.copyOf(this.getDataArray(), this.getDataArray().length));
        }

        @Override
        public double get(int row, int col) {
            if (row >= col) {
                int a2 = (row * (row - 1) >> 1) + col - 1;
                return this.data[a2];
            }
            return 0.0;
        }

        @Override
        public void set(int row, int col, double value) {
            if (row < col) {
                return;
            }
            int a2 = (row * (row - 1) >> 1) + col - 1;
            this.data[a2] = value;
        }

        public MyDenseDataImpl(double[] a2) {
            super(a2);
            MyDenseDataImpl a3;
        }

        public MyDenseDataImpl(int a2) {
            super(a2);
            MyDenseDataImpl a3;
        }
    }
}

