/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalData;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalDataMatrix;
import com.numericalmethod.suanshu.misc.R;

public class TridiagonalMatrix
extends DiagonalDataMatrix<TridiagonalMatrix> {
    @Override
    public TridiagonalMatrix t() {
        double[][] dArrayArray = new double[3][];
        double[][] a2 = dArrayArray;
        dArrayArray[0] = this.diagonalData.getSubDiagonal();
        a2[1] = this.diagonalData.getDiagonal();
        a2[2] = this.diagonalData.getSuperDiagonal();
        return new TridiagonalMatrix(a2);
    }

    @Override
    public TridiagonalMatrix add(TridiagonalMatrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        DiagonalData a2 = this.diagonalData.add(that.diagonalData);
        return new TridiagonalMatrix(a2);
    }

    private TridiagonalMatrix(DiagonalData a2) {
        super(a2);
        TridiagonalMatrix a3;
    }

    public TridiagonalMatrix(TridiagonalMatrix that) {
        this(that.diagonalData.deepCopy());
    }

    @Override
    public TridiagonalMatrix ZERO() {
        return new TridiagonalMatrix(this.diagonalData.dim);
    }

    @Override
    public TridiagonalMatrix scaled(double scalar) {
        DiagonalData a2 = this.diagonalData.scaled(scalar);
        return new TridiagonalMatrix(a2);
    }

    public TridiagonalMatrix(int dim) {
        this(new DiagonalData(DiagonalData.Type.TRI_DIAGONAL, dim));
    }

    @Override
    public TridiagonalMatrix ONE() {
        double[][] a2 = new double[3][];
        int a3 = this.diagonalData.dim;
        a2[0] = R.rep(0.0, a3 - 1);
        a2[1] = R.rep(1.0, a3);
        a2[2] = R.rep(0.0, a3 - 1);
        return new TridiagonalMatrix(a2);
    }

    @Override
    public TridiagonalMatrix deepCopy() {
        return new TridiagonalMatrix(this);
    }

    public TridiagonalMatrix(double[][] data) {
        this(TridiagonalMatrix.b(data));
    }

    @Override
    public TridiagonalMatrix minus(TridiagonalMatrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        DiagonalData a2 = this.diagonalData.minus(that.diagonalData);
        return new TridiagonalMatrix(a2);
    }

    @Deprecated
    private TridiagonalMatrix b(TridiagonalMatrix a2) {
        throw new UnsupportedOperationException("TridiagonalMatrices do not constitute a Monoid.");
    }

    private static DiagonalData b(double[][] a2) {
        if (a2.length != 3) {
            throw new IllegalArgumentException("tridiagonal matrix data must have 3 rows");
        }
        int a3 = 0;
        if (a2[0] != null) {
            a3 = a2[0].length + 1;
        } else if (a2[1] != null) {
            a3 = a2[1].length;
        } else if (a2[2] != null) {
            a3 = a2[2].length + 1;
        } else {
            throw new IllegalArgumentException("there must be at least one non-null row");
        }
        double[][] dArrayArray = new double[3][];
        double[][] a4 = dArrayArray;
        dArrayArray[0] = a2[0] != null ? a2[0] : R.rep(0.0, a3 - 1);
        a4[1] = a2[1] != null ? a2[1] : R.rep(0.0, a3);
        a4[2] = a2[2] != null ? a2[2] : R.rep(0.0, a3 - 1);
        return new DiagonalData(a4);
    }
}

