/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal;

import com.numericalmethod.suanshu.matrix.doubles.AreMatrices;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.MatrixStorageImpl;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.Densifiable;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalData;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public abstract class DiagonalDataMatrix<T extends DiagonalDataMatrix>
extends MatrixStorageImpl<T>
implements Densifiable {
    public DiagonalData diagonalData;

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiagonalDataMatrix) && obj instanceof Matrix) {
            return AreMatrices.equal(this, (Matrix)obj, 0.0);
        }
        DiagonalDataMatrix a2 = (DiagonalDataMatrix)obj;
        if (this.diagonalData.dim != a2.diagonalData.dim) {
            return false;
        }
        if (!(this.diagonalData == a2.diagonalData || this.diagonalData != null && this.diagonalData.equals(a2.diagonalData))) {
            return false;
        }
        return true;
    }

    @Override
    public DenseVector getColumn(int col) {
        DenseVector a2 = new DenseVector(this.diagonalData.dim);
        if (col > 1) {
            a2.set(col - 1, this.get(col - 1, col));
        }
        a2.set(col, this.get(col, col));
        if (col < this.diagonalData.dim) {
            a2.set(col + 1, this.get(col + 1, col));
        }
        return a2;
    }

    @Override
    public DenseVector getRow(int row) {
        DenseVector a2 = new DenseVector(this.diagonalData.dim);
        if (row > 1) {
            a2.set(row - 1, this.get(row, row - 1));
        }
        a2.set(row, this.get(row, row));
        if (row < this.diagonalData.dim) {
            a2.set(row + 1, this.get(row, row + 1));
        }
        return a2;
    }

    public DenseVector getDiagonal() {
        return new DenseVector(this.diagonalData.getDiagonal());
    }

    @Override
    public int hashCode() {
        int a2 = 7;
        a2 = 79 * a2 + this.diagonalData.dim;
        a2 = 79 * a2 + (this.diagonalData != null ? this.diagonalData.hashCode() : 0);
        return a2;
    }

    public DenseVector getSuperDiagonal() {
        return new DenseVector(this.diagonalData.getSuperDiagonal());
    }

    @Override
    public DenseMatrix toDense() {
        return this.diagonalData.toDense();
    }

    @Override
    public String toString() {
        return this.diagonalData.toString();
    }

    public DenseVector getSubDiagonal() {
        return new DenseVector(this.diagonalData.getSubDiagonal());
    }

    public DiagonalDataMatrix(DiagonalData a2) {
        super(a2.dim, a2.dim, a2);
        DiagonalDataMatrix a3;
        a3.diagonalData = a2;
    }
}

