/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.matrix.MatrixDimension;
import com.numericalmethod.suanshu.matrix.doubles.AreMatrices;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.MatrixMathImpl;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class PermutationMatrix
extends MatrixMathImpl<PermutationMatrix> {
    private final int k;
    private int L = 1;
    private int[] E;

    public PermutationMatrix(PermutationMatrix P) {
        super(P.k, P.k);
        this.k = P.k;
        this.E = Arrays.copyOf(P.E, P.E.length);
        this.L = P.L;
    }

    @Override
    public Matrix add(Matrix that) {
        int a2;
        DimensionCheck.throwIfDifferentDimension(this, that);
        DenseMatrix a3 = new DenseMatrix(that);
        int n = a2 = 1;
        while (n < this.E.length) {
            a3.set(a2, this.E[a2], 1.0 + a3.get(a2, this.E[a2]));
            n = ++a2;
        }
        return a3;
    }

    @Override
    @Deprecated
    public void set(int row, int col, double value) throws MatrixAccessException {
        throw new UnsupportedOperationException("Please use swapRow or swapColumn instead.");
    }

    @Override
    public Vector getColumn(int col) throws MatrixAccessException {
        int a2;
        DimensionCheck.throwIfInvalidColumn(this, col);
        DenseVector a3 = new DenseVector(this.k);
        int n = a2 = 1;
        while (n <= this.k) {
            if (this.E[a2] == col) {
                a3.set(a2, 1.0);
                break;
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public Matrix minus(Matrix that) {
        int a2;
        DimensionCheck.throwIfDifferentDimension(this, that);
        DenseMatrix a3 = new DenseMatrix(that);
        int n = a2 = 1;
        while (n < this.E.length) {
            a3.set(a2, this.E[a2], 1.0 - a3.get(a2, this.E[a2]));
            n = ++a2;
        }
        return a3;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermutationMatrix) && obj instanceof Matrix) {
            return AreMatrices.equal(this, (Matrix)obj, 0.0);
        }
        PermutationMatrix a2 = (PermutationMatrix)obj;
        if (this.k != a2.k) {
            return false;
        }
        if (!(this.E == a2.E || this.E != null && Arrays.equals(this.E, a2.E))) {
            return false;
        }
        return true;
    }

    @Override
    public PermutationMatrix deepCopy() {
        return new PermutationMatrix(this);
    }

    public void swapColumn(int col1, int col2) {
        int a2;
        DimensionCheck.throwIfInvalidColumn(this, col1);
        DimensionCheck.throwIfInvalidColumn(this, col2);
        int n = a2 = 1;
        while (n <= this.k) {
            if (this.E[a2] == col1) {
                this.E[a2] = col2;
            } else if (this.E[a2] == col2) {
                this.E[a2] = col1;
            }
            n = ++a2;
        }
        this.L *= -1;
    }

    public Matrix rightMultiply(Matrix A) {
        int a2;
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)A, this);
        Vector[] a3 = new Vector[A.nCols()];
        int n = a2 = 1;
        while (n <= A.nCols()) {
            a3[this.E[a2] - 1] = A.getColumn(a2);
            n = ++a2;
        }
        DenseMatrix denseMatrix = CreateMatrix.cbind(a3);
        return denseMatrix;
    }

    public void swapRow(int row1, int row2) {
        DimensionCheck.throwIfInvalidRow(this, row1);
        DimensionCheck.throwIfInvalidRow(this, row2);
        int a2 = this.E[row1];
        this.E[row1] = this.E[row2];
        this.E[row2] = a2;
        this.L *= -1;
    }

    public void moveRow2End(int row) {
        int a2;
        DimensionCheck.throwIfInvalidRow(this, row);
        int a3 = this.E[row];
        int n = a2 = row;
        while (n < this.nRows()) {
            this.E[a2] = this.E[a2 + 1];
            n = ++a2;
        }
        this.E[this.nRows()] = a3;
    }

    @Override
    public Vector multiply(Vector v) {
        int a2;
        double[] a3 = new double[v.size()];
        int n = a2 = 0;
        while (n < a3.length) {
            a3[a2] = v.get(this.E[a2 + 1]);
            n = ++a2;
        }
        DenseVector denseVector = new DenseVector(a3);
        return denseVector;
    }

    public void moveColumn2End(int col) {
        int a2;
        DimensionCheck.throwIfInvalidColumn(this, col);
        int n = a2 = 1;
        while (n <= this.nRows()) {
            if (this.E[a2] == col) {
                this.E[a2] = this.nCols();
            } else if (this.E[a2] > col) {
                int n2 = a2;
                this.E[n2] = this.E[n2] - 1;
            }
            n = ++a2;
        }
    }

    @Override
    public double get(int row, int col) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, row);
        double a2 = 0.0;
        if (this.E[row] == col) {
            a2 = 1.0;
        }
        return a2;
    }

    @Override
    public Matrix ZERO() {
        throw new UnsupportedOperationException("permutation matrix cannot be zero");
    }

    @Override
    public PermutationMatrix ONE() {
        return new PermutationMatrix(this.k);
    }

    @Override
    public Vector getRow(int row) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DenseVector a2 = new DenseVector(this.k);
        a2.set(this.E[row], 1.0);
        return a2;
    }

    public PermutationMatrix(int[] data) {
        super(data.length, data.length);
        int a2;
        int a3;
        this.k = data.length;
        this.E = new int[this.k + 1];
        boolean[] a4 = new boolean[this.k + 1];
        int n = a3 = 1;
        while (n <= this.k) {
            this.E[a3] = a2 = data[a3 - 1];
            a4[a2] = true;
            n = ++a3;
        }
        a3 = 1;
        int n2 = a2 = 1;
        while (n2 <= this.k) {
            a3 &= a4[a2];
            n2 = ++a2;
        }
        if (a3 == 0) {
            throw new IllegalArgumentException("data is not a permutation matrix");
        }
    }

    public int hashCode() {
        int a2 = 5;
        a2 = 59 * a2 + this.k;
        a2 = 59 * a2 + (this.E != null ? this.E.hashCode() : 0);
        return a2;
    }

    @Override
    public Matrix multiply(Matrix A) {
        int a2;
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)this, A);
        Vector[] a3 = new Vector[A.nRows()];
        int n = a2 = 0;
        while (n < A.nRows()) {
            a3[a2] = A.getRow(this.E[a2 + 1]);
            n = ++a2;
        }
        DenseMatrix denseMatrix = CreateMatrix.rbind(a3);
        return denseMatrix;
    }

    @Override
    public Matrix scaled(double scalar) {
        int a2;
        DenseMatrix a3 = new DenseMatrix(this.k, this.k);
        int n = a2 = 1;
        while (n < this.E.length) {
            a3.set(a2, this.E[a2], scalar);
            n = ++a2;
        }
        return a3;
    }

    @Override
    public PermutationMatrix t() {
        int a2;
        PermutationMatrix a3 = new PermutationMatrix(this.k);
        int n = a2 = 1;
        while (n <= this.k) {
            a3.E[this.E[a2]] = a2;
            n = ++a2;
        }
        return a3;
    }

    public PermutationMatrix(int dim) {
        super(dim, dim);
        int a2;
        this.k = dim;
        this.E = new int[dim + 1];
        int n = a2 = 0;
        while (n <= dim) {
            this.E[a2] = a2;
            n = ++a2;
        }
    }

    public double sign() {
        return Math.signum(this.L);
    }
}

