/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype;

import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation.SimpleMatrixMathOperation;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.lang.reflect.InvocationTargetException;

public abstract class MatrixMathImpl<T extends Matrix>
implements Matrix {
    private final int F;
    private T k = null;
    private final int L;
    private final MatrixMathOperation E;

    @Override
    public Matrix add(Matrix that) {
        try {
            if (this.getSample().getClass().isInstance(that)) {
                return this.call("add", that);
            }
        }
        catch (NoSuchMethodException a2) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return this.E.add(this, that);
    }

    public T call(String op, Matrix that) throws NoSuchMethodException, IllegalAccessException {
        try {
            Class<?> a2 = this.getSample().getClass();
            Class[] classArray = new Class[1];
            classArray[0] = a2;
            Object[] objectArray = new Object[1];
            objectArray[0] = that;
            Matrix a3 = (Matrix)a2.getDeclaredMethod(op, classArray).invoke((Object)this, objectArray);
            return (T)a3;
        }
        catch (InvocationTargetException a4) {
            throw (RuntimeException)a4.getCause();
        }
    }

    public void setColumn(int col, Vector v) {
        int a2;
        DimensionCheck.throwIfInvalidColumn(this, col);
        int a3 = v.size();
        if (a3 != this.nRows()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a3;
            objectArray[1] = this.nRows();
            throw new MatrixAccessException(String.format("the number of values (%d) does not match the row size (%d)", objectArray));
        }
        int n = a2 = 1;
        while (n <= a3) {
            this.set(a2, col, v.get(a2));
            n = ++a2;
        }
    }

    @Override
    public Matrix t() {
        return this.E.transpose(this);
    }

    @Override
    public Matrix minus(Matrix that) {
        try {
            if (this.getSample().getClass().isInstance(that)) {
                return this.call("minus", that);
            }
        }
        catch (NoSuchMethodException a2) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return this.E.minus(this, that);
    }

    @Override
    public Matrix scaled(double scalar) {
        return this.E.scaled(this, scalar);
    }

    public MatrixMathImpl(int nRows, int nCols) {
        this(nRows, nCols, new SimpleMatrixMathOperation());
    }

    @Override
    public int nCols() {
        return this.F;
    }

    @Override
    public int nRows() {
        return this.L;
    }

    public void setColumn(int col, double ... values) {
        int a2;
        DimensionCheck.throwIfInvalidColumn(this, col);
        if (values.length != this.nRows()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = values.length;
            objectArray[1] = this.nRows();
            throw new MatrixAccessException(String.format("the number of values (%d) does not match the row size (%d)", objectArray));
        }
        int n = a2 = 1;
        while (n <= values.length) {
            this.set(a2, col, values[a2 - 1]);
            n = ++a2;
        }
    }

    public void setRow(int row, Vector v) {
        int a2;
        DimensionCheck.throwIfInvalidRow(this, row);
        int a3 = v.size();
        if (a3 != this.nCols()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a3;
            objectArray[1] = this.nCols();
            throw new MatrixAccessException(String.format("the number of values (%d) does not match the column size (%d)", objectArray));
        }
        int n = a2 = 1;
        while (n <= a3) {
            this.set(row, a2, v.get(a2));
            n = ++a2;
        }
    }

    static {
        Package.getInstance("BASIC").isValidated();
    }

    @Override
    public Matrix multiply(Matrix that) {
        try {
            if (this.getSample().getClass().isInstance(that)) {
                return this.call("multiply", that);
            }
        }
        catch (NoSuchMethodException a2) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return this.E.multiply((Matrix)this, that);
    }

    @Override
    public Vector getColumn(int col) throws MatrixAccessException {
        int a2;
        DimensionCheck.throwIfInvalidColumn(this, col);
        DenseVector a3 = new DenseVector(this.nRows());
        int n = a2 = 1;
        while (n <= a3.length) {
            a3.set(a2, this.get(a2, col));
            n = ++a2;
        }
        return a3;
    }

    @Override
    public Vector getRow(int row) throws MatrixAccessException {
        int a2;
        DimensionCheck.throwIfInvalidRow(this, row);
        DenseVector a3 = new DenseVector(this.nCols());
        int n = a2 = 1;
        while (n <= a3.length) {
            a3.set(a2, this.get(row, a2));
            n = ++a2;
        }
        return a3;
    }

    @Override
    public Vector multiply(Vector v) {
        return this.E.multiply((Matrix)this, v);
    }

    public void setRow(int row, double ... values) {
        int a2;
        DimensionCheck.throwIfInvalidRow(this, row);
        if (values.length != this.nCols()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = values.length;
            objectArray[1] = this.nCols();
            throw new MatrixAccessException(String.format("the number of values (%d) does not match the column size (%d)", objectArray));
        }
        int n = a2 = 1;
        while (n <= values.length) {
            this.set(row, a2, values[a2 - 1]);
            n = ++a2;
        }
    }

    public MatrixMathImpl(int nRows, int nCols, MatrixMathOperation math) {
        this.L = nRows;
        this.F = nCols;
        this.E = math;
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        Object[] objectArray = new Object[2];
        objectArray[0] = this.L;
        objectArray[1] = this.F;
        a3.append(String.format("%dx%d\n", objectArray));
        a3.append("\t");
        int n = a2 = 1;
        while (n <= this.F) {
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = a2;
            a3.append(String.format("[,%d] ", objectArray2));
            n = ++a2;
        }
        a3.append("\n");
        int n2 = a2 = 1;
        while (n2 <= this.L) {
            int a4;
            Object[] objectArray3 = new Object[1];
            objectArray3[0] = a2;
            a3.append(String.format("[%d,] ", objectArray3));
            int n3 = a4 = 1;
            while (n3 <= this.F) {
                Object[] objectArray4 = new Object[1];
                objectArray4[0] = this.get(a2, a4);
                a3.append(String.format("%f, ", objectArray4));
                n3 = ++a4;
            }
            if (a2 != this.L) {
                a3.append("\n");
            }
            n2 = ++a2;
        }
        return a3.toString();
    }

    public T getSample() {
        if (this.k == null) {
            this.k = this.ZERO();
        }
        return this.k;
    }

    @Override
    public Matrix opposite() {
        return this.scaled(-1.0);
    }
}

