/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.matrix.MatrixDimension;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.MatrixMathImpl;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class GivensMatrix
extends MatrixMathImpl<GivensMatrix> {
    private final double G;
    private final int F;
    private final double k;
    private final int L;
    private final int E;

    @Override
    public String toString() {
        DenseMatrix a2 = new DenseMatrix(this.L, this.L).ONE();
        a2.set(this.F, this.F, this.G);
        a2.set(this.E, this.E, this.G);
        a2.set(this.F, this.E, this.k);
        a2.set(this.E, this.F, -this.k);
        return ((Object)a2).toString();
    }

    public Matrix rightMultiply(Matrix A) {
        int a2;
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)A, this);
        DenseMatrix a3 = new DenseMatrix(A);
        int n = a2 = 1;
        while (n <= A.nRows()) {
            double a4 = a3.get(a2, this.F);
            double a5 = a3.get(a2, this.E);
            a3.set(a2, this.F, this.G * a4 - this.k * a5);
            a3.set(a2, this.E, this.k * a4 + this.G * a5);
            n = ++a2;
        }
        return a3;
    }

    @Override
    public GivensMatrix ONE() {
        return new GivensMatrix(this.L, 1, 2, 1.0, 0.0);
    }

    public static GivensMatrix Ctor2x2(double c2, double s2) {
        return new GivensMatrix(2, 1, 2, c2, s2);
    }

    @Override
    @Deprecated
    public void set(int row, int col, double value) {
        throw new MatrixAccessException("GivensMatrix is immutable");
    }

    public GivensMatrix(GivensMatrix that) {
        this(that.L, that.F, that.E, that.G, that.k);
    }

    @Override
    public GivensMatrix t() {
        return new GivensMatrix(this.L, this.F, this.E, this.G, -this.k);
    }

    public static GivensMatrix CtorToZeroOutEntryByTranspose(Matrix A, int i2, int j) {
        double a2 = A.get(i2 == 1 ? A.nRows() : i2 - 1, j);
        double a3 = A.get(i2, j);
        return GivensMatrix.CtorToRotateColumns(A.nRows(), i2 == 1 ? A.nRows() : i2 - 1, i2, a2, a3);
    }

    @Override
    public Vector getRow(int row) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DenseVector a2 = new DenseVector(this.L, 0.0);
        a2.set(row, this.get(row, row));
        a2.set(this.F, this.get(row, this.F));
        a2.set(this.E, this.get(row, this.E));
        return a2;
    }

    @Override
    @Deprecated
    public Matrix ZERO() {
        throw new UnsupportedOperationException("no zero matrix for GivensMatrix");
    }

    @Override
    public double get(int row, int col) {
        if (row == this.F && col == this.F) {
            return this.G;
        }
        if (row == this.E && col == this.E) {
            return this.G;
        }
        if (row == this.F && col == this.E) {
            return this.k;
        }
        if (row == this.E && col == this.F) {
            return -this.k;
        }
        if (row == col) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public Vector multiply(Vector v) {
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)this, v);
        Vector a2 = v.deepCopy();
        a2.set(this.F, v.get(this.F) * this.G + v.get(this.E) * this.k);
        a2.set(this.E, v.get(this.E) * this.G - v.get(this.F) * this.k);
        return a2;
    }

    public static GivensMatrix CtorToRotateColumns(int dim, int col1, int col2, double a2, double b2) {
        double a3;
        double a4;
        double a5 = Math.abs(a2) + Math.abs(b2);
        if (DoubleUtils.compare(a5, 0.0) == 0) {
            a4 = 1.0;
            a3 = 0.0;
        } else {
            double a6 = a5 * Math.sqrt(a2 / a5 * a2 / a5 + b2 / a5 * b2 / a5);
            a4 = a2 / a6;
            a3 = b2 / a6;
        }
        return new GivensMatrix(dim, col1, col2, a4, -a3);
    }

    @Override
    public GivensMatrix deepCopy() {
        return new GivensMatrix(this);
    }

    public static GivensMatrix CtorToRotateRows(int dim, int row1, int row2, double a2, double b2) {
        double a3;
        double a4;
        double a5 = Math.abs(a2) + Math.abs(b2);
        if (DoubleUtils.compare(a5, 0.0) == 0) {
            a4 = 1.0;
            a3 = 0.0;
        } else {
            double a6 = a5 * Math.sqrt(a2 / a5 * a2 / a5 + b2 / a5 * b2 / a5);
            a4 = a2 / a6;
            a3 = b2 / a6;
        }
        return new GivensMatrix(dim, row1, row2, a4, a3);
    }

    @Deprecated
    public Vector rotate(Vector x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static GivensMatrix CtorFromRho(int dim, int i2, int j, double rho) {
        double a2;
        double a3;
        SuanShuUtils.assertArgument(0 < i2, "incorrect dimension", new Object[0]);
        SuanShuUtils.assertArgument(0 < j, "incorrect dimension", new Object[0]);
        SuanShuUtils.assertArgument(i2 <= dim, "incorrect dimension", new Object[0]);
        SuanShuUtils.assertArgument(j <= dim, "incorrect dimension", new Object[0]);
        SuanShuUtils.assertArgument(i2 != j, "invalid specification", new Object[0]);
        if (DoubleUtils.compare(rho, 1.0) == 0) {
            a3 = 1.0;
            a2 = 0.0;
        } else if (DoubleUtils.compare(Math.abs(rho), 1.0) < 0) {
            a3 = 2.0 * rho;
            a2 = Math.sqrt(1.0 - a3 * a3);
        } else {
            a2 = 2.0 / rho;
            a3 = Math.sqrt(1.0 - a2 * a2);
        }
        return new GivensMatrix(dim, i2, j, a2, a3);
    }

    public double rho() {
        double a2 = DoubleUtils.compare(this.G, 0.0) == 0 ? 1.0 : (DoubleUtils.compare(Math.abs(this.k), Math.abs(this.G)) < 0 ? Math.signum(this.G) * this.k / 2.0 : 2.0 * Math.signum(this.k) / this.G);
        return a2;
    }

    @Override
    public Vector getColumn(int col) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, col);
        DenseVector a2 = new DenseVector(this.L, 0.0);
        a2.set(col, this.get(col, col));
        a2.set(this.F, this.get(this.F, col));
        a2.set(this.E, this.get(this.E, col));
        return a2;
    }

    @Override
    public Matrix multiply(Matrix A) {
        int a2;
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)this, A);
        DenseMatrix a3 = new DenseMatrix(A);
        int n = a2 = 1;
        while (n <= A.nCols()) {
            double a4 = a3.get(this.F, a2);
            double a5 = a3.get(this.E, a2);
            a3.set(this.F, a2, this.G * a4 + this.k * a5);
            a3.set(this.E, a2, -this.k * a4 + this.G * a5);
            n = ++a2;
        }
        return a3;
    }

    public GivensMatrix(int dim, int i2, int j, double c2, double s2) {
        super(dim, dim);
        SuanShuUtils.assertArgument(0 < i2, "incorrect dimension", new Object[0]);
        SuanShuUtils.assertArgument(0 < j, "incorrect dimension", new Object[0]);
        SuanShuUtils.assertArgument(i2 <= dim, "incorrect dimension", new Object[0]);
        SuanShuUtils.assertArgument(j <= dim, "incorrect dimension", new Object[0]);
        SuanShuUtils.assertArgument(i2 != j, "invalid specification", new Object[0]);
        this.L = dim;
        this.F = i2;
        this.E = j;
        this.G = c2;
        this.k = s2;
    }

    public static Matrix product(GivensMatrix[] Gs) {
        int a2;
        Matrix a3 = null;
        int n = a2 = Gs.length - 1;
        while (n >= 0) {
            if (Gs[a2] != null) {
                if (a3 == null) {
                    a3 = new DenseMatrix(Gs[a2].L, Gs[a2].L).ONE();
                }
                a3 = Gs[a2].multiply(a3);
            }
            n = --a2;
        }
        return a3;
    }

    public static GivensMatrix CtorToZeroOutEntry(Matrix A, int i2, int j) {
        double a2 = A.get(i2 == 1 ? A.nRows() : i2 - 1, j);
        double a3 = A.get(i2, j);
        return GivensMatrix.CtorToRotateRows(A.nRows(), i2 == 1 ? A.nRows() : i2 - 1, i2, a2, a3);
    }
}

