/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.linearsystem;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.PseudoInverse;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class OLSSolverBySVD {
    private final int L;
    private final PseudoInverse E;

    public OLSSolverBySVD(Matrix A) {
        this(A, SuanShuUtils.autoEpsilon(A));
    }

    public OLSSolverBySVD(Matrix A, double epsilon) {
        this.L = A.nRows();
        this.E = new PseudoInverse(A, epsilon);
    }

    public Vector solve(Vector y) {
        SuanShuUtils.assertArgument(y.size() == this.L, "y does not have the correct length", new Object[0]);
        return this.E.multiply(y);
    }
}

