/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.linearsystem;

import com.numericalmethod.suanshu.datastructure.list.VectorList;
import com.numericalmethod.suanshu.matrix.doubles.IsMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.svd.SVD;
import com.numericalmethod.suanshu.matrix.doubles.linearsystem.Kernel;
import com.numericalmethod.suanshu.matrix.doubles.linearsystem.LUSolver;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;

public class LinearSystemSolver {
    public final double epsilon;
    private final Matrix k;
    public final Matrix A;
    private final Matrix L;
    public final boolean isFullRank;
    private final SVD E;
    public final VectorList basis;

    public LinearSystemSolver(Matrix A1, double epsilon) {
        if (A1.nRows() <= A1.nCols()) {
            this.E = null;
            this.A = A1;
        } else {
            this.E = new SVD(A1, true);
            this.A = this.E.D().multiply(this.E.V().t());
        }
        SuanShuUtils.assertArgument(this.A.nRows() <= this.A.nCols(), "Ax = b is an over-determined system. Please consider using OLS methods", new Object[0]);
        Kernel a2 = new Kernel(this.A, Kernel.Method.QR, epsilon);
        this.isFullRank = a2.isZero();
        this.basis = a2.basis();
        this.k = a2.T();
        this.L = a2.U();
        this.epsilon = epsilon;
    }

    public VectorList getHomogeneousSoln() {
        return new VectorList(this.basis);
    }

    public Vector solve(Vector b1) {
        Vector a2;
        Vector a3 = b1;
        if (this.E != null) {
            a3 = this.E.Ut().multiply(b1);
        }
        SuanShuUtils.assertArgument(this.A.nRows() == a3.size(), "A's dimension must equal to b's length (after row reduction)", new Object[0]);
        if (this.isFullRank) {
            LUSolver a4 = new LUSolver(this.A);
            a2 = a4.solve(a3);
        } else if (IsMatrix.zero(a3, this.epsilon)) {
            a2 = new DenseVector(this.A.nCols()).ZERO();
        } else {
            int a5;
            a2 = this.k.multiply(a3);
            int n = a5 = 1;
            while (n <= a2.size()) {
                if (IsMatrix.zero(this.L.getRow(a5), this.epsilon) && DoubleUtils.compare(a2.get(a5), 0.0, this.epsilon) != 0) {
                    throw new NoSolution("the system of linear equation is inconsistent");
                }
                n = ++a5;
            }
            if (this.A.nCols() > a2.size()) {
                Vector[] vectorArray = new Vector[2];
                vectorArray[0] = a2;
                vectorArray[1] = new DenseVector(R.rep(0.0, this.A.nCols() - a2.size()));
                a2 = CreateVector.concat(vectorArray);
            }
        }
        return a2;
    }

    public LinearSystemSolver(Matrix A1) {
        this(A1, SuanShuUtils.autoEpsilon(A1));
    }

    public static class NoSolution
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NoSolution(String msg) {
            super(msg);
        }
    }
}

