/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.linearsystem;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixSingularityException;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.triangle.LU;
import com.numericalmethod.suanshu.matrix.doubles.linearsystem.BackwardSubstitution;
import com.numericalmethod.suanshu.matrix.doubles.linearsystem.ForwardSubstitution;
import com.numericalmethod.suanshu.matrix.doubles.linearsystem.LinearSystemSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.PermutationMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class LUSolver {
    public final LowerTriangularMatrix L;
    public final UpperTriangularMatrix U;
    private final int E;
    public final PermutationMatrix P;

    public LUSolver(Matrix A) {
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(A), "A must be a square matrix", new Object[0]);
        this.E = A.nRows();
        try {
            LU a2 = new LU(A, LU.Method.DOOLITTLE, 0.0);
            this.L = a2.L();
            this.U = a2.U();
            this.P = a2.P();
        }
        catch (MatrixSingularityException a3) {
            throw new LinearSystemSolver.NoSolution("no solution to this system of linear equations");
        }
    }

    public Vector solve(Vector b2) {
        SuanShuUtils.assertArgument(this.E == b2.size(), "A's dimension must equal to b's length", new Object[0]);
        Vector a2 = this.P.multiply(b2);
        Vector a3 = new ForwardSubstitution(this.L).solve(a2);
        BackwardSubstitution a4 = new BackwardSubstitution(this.U);
        Vector a5 = a4.solve(a3);
        return a5;
    }
}

