/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.linearsystem;

import com.numericalmethod.suanshu.datastructure.list.VectorList;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.gaussianelimination.GaussJordanElimination;
import com.numericalmethod.suanshu.matrix.doubles.factorization.qr.HouseholderReflection;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Kernel {
    public final double epsilon;
    private Matrix k;
    private Map<Integer, Vector> L;
    public final int ncols;
    public final int nrows;
    public final Method method;
    private Matrix E;

    public VectorList basis() {
        Iterator<Map.Entry<Integer, Vector>> a2;
        VectorList a3 = new VectorList();
        Iterator<Map.Entry<Integer, Vector>> iterator = a2 = this.L.entrySet().iterator();
        while (iterator.hasNext()) {
            Vector a4 = a2.next().getValue().deepCopy();
            a3.add(a4);
            iterator = a2;
        }
        return a3;
    }

    public Matrix T() {
        return this.E.deepCopy();
    }

    public Kernel(Matrix A) {
        this(A, Method.QR, SuanShuUtils.autoEpsilon(A));
    }

    public Kernel(Matrix A, Method method, double epsilon) {
        SuanShuUtils.assertArgument(A.nCols() >= A.nRows(), "cannot compute for an over-determined system", new Object[0]);
        this.nrows = A.nRows();
        this.ncols = A.nCols();
        this.method = method;
        this.epsilon = epsilon;
        GaussJordanElimination a2 = new GaussJordanElimination(A, true, epsilon);
        this.k = a2.U();
        this.E = a2.T();
        this.L = new HashMap<Integer, Vector>();
        switch (this.method) {
            case GAUSSIAN_JORDAN_ELIMINATION: {
                do {
                } while (false);
                this.b();
                break;
            }
            default: {
                this.b(A);
            }
        }
    }

    public int nullity() {
        return this.L.size();
    }

    public Matrix U() {
        return this.k.deepCopy();
    }

    public boolean isZero() {
        return this.L.isEmpty();
    }

    private void b(Matrix a2) {
        int a3;
        Kernel a4;
        Matrix a5 = a2.t();
        HouseholderReflection a6 = new HouseholderReflection(a5, a4.epsilon);
        Matrix a7 = a6.squareQ();
        int a8 = a6.rank();
        int n = a3 = a8 + 1;
        while (n <= a7.nCols()) {
            Vector a9 = a7.getColumn(a3);
            a9 = a9.scaled(1.0 / a9.norm());
            a4.L.put(new Integer(a3 - a8), a9);
            n = ++a3;
        }
    }

    private void b() {
        Iterator<Integer> a2;
        int a3;
        Kernel a4;
        int a5;
        int n = a5 = 1;
        while (n <= a4.ncols) {
            a4.L.put(new Integer(a5), null);
            n = ++a5;
        }
        HashMap<Integer, Integer> a22 = new HashMap<Integer, Integer>();
        int n2 = a3 = 1;
        while (n2 <= a4.nrows) {
            int n3 = a3;
            while (n3 <= a4.ncols) {
                int a6;
                if (a4.k.get(a3, a6) == 1.0) {
                    a4.L.remove(new Integer(a6));
                    a22.put(new Integer(a6), new Integer(a3));
                    break;
                }
                n3 = ++a6;
            }
            n2 = ++a3;
        }
        Set<Integer> a32 = a4.L.keySet();
        Iterator<Integer> iterator = a2 = a32.iterator();
        while (iterator.hasNext()) {
            Iterator a7;
            Integer a8 = a2.next();
            DenseVector a9 = new DenseVector(a4.ncols);
            a9.set((int)a8, 1.0);
            Iterator iterator2 = a7 = a22.keySet().iterator();
            while (iterator2.hasNext()) {
                Integer a10 = (Integer)a7.next();
                int a11 = (Integer)a22.get(a10);
                double a12 = a4.k.get(a11, a8);
                a9.set((int)a10, -a12);
                iterator2 = a7;
            }
            a4.L.put(a8, a9);
            iterator = a2;
        }
    }

    public Map<Integer, Vector> basisAndFreeVars() {
        Iterator<Integer> a2;
        HashMap<Integer, Vector> a3 = new HashMap<Integer, Vector>();
        Iterator<Integer> iterator = a2 = this.L.keySet().iterator();
        while (iterator.hasNext()) {
            Integer a4 = a2.next();
            Vector a5 = this.L.get(a4).deepCopy();
            a3.put(a4, a5);
            iterator = a2;
        }
        return a3;
    }

    public int rank() {
        return this.ncols - this.L.size();
    }

    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method GAUSSIAN_JORDAN_ELIMINATION;
        public static final /* enum */ Method QR;
        private static final /* synthetic */ Method[] E;

        public static Method[] values() {
            return (Method[])E.clone();
        }

        static {
            QR = new Method();
            GAUSSIAN_JORDAN_ELIMINATION = new Method();
            Method[] methodArray = new Method[2];
            methodArray[0] = QR;
            methodArray[1] = GAUSSIAN_JORDAN_ELIMINATION;
            E = methodArray;
        }

        private Method() {
            Method a2;
        }

        public static Method valueOf(String name) {
            return Enum.valueOf(Method.class, name);
        }
    }
}

